// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#include "editbar.h"
#include "cooldialogbar.h"
#include "ansiwnd.h"

class CInvertSplit : public CSplitterWnd 
{
public:
    BOOL SplitRow( );
    void SavePosition();

    int m_nUpSize, m_nDownSize;    

    BOOL m_bInited;

protected:

protected:
	//{{AFX_MSG(CInvertSplit)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// COutputBar window

class COutputBar : public CCoolDialogBar
{
// Construction
public:
	COutputBar();

// Attributes
public:
    CAnsiWnd m_wndAnsi;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COutputBar)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COutputBar();

	// Generated message map functions
protected:
	//{{AFX_MSG(COutputBar)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CJMCStatus : public CStatusBar
{
protected:
    CBitmap m_bmpConnected, m_bmpLogged, m_bmpMarked;

public:    
    CJMCStatus();
    virtual void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct );
};

/////////////////////////////////////////////////////////////////////////////

class CMainFrame : public CFrameWnd
{
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

    CString m_strInfo1, m_strInfo2, m_strInfo3;

// Attributes
public:
    CEditBar m_editBar;
    COutputBar m_coolBar;

    virtual void OnUpdateFrameTitle(BOOL);
    
    CInvertSplit m_wndSplitter;


// Operations
public:
	void RestorePosition();
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();

    // virtual void OnUpdateFrameTitle(BOOL);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CJMCStatus  m_wndStatusBar;
	CToolBar    m_wndToolBar;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnOptionsOptions();
	afx_msg void OnDestroy();
	afx_msg void OnUnsplit();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnEditJmcobjects();
	//}}AFX_MSG
    afx_msg void OnUpdateLogged(CCmdUI* pUI);
    afx_msg void OnUpdateConnected(CCmdUI* pUI);
    afx_msg void OnUpdatePath(CCmdUI* pUI);
    afx_msg void OnUpdateTicker(CCmdUI* pUI);
    afx_msg BOOL OnBarCheckEx(UINT nID);

    afx_msg void OnUpdateInfo1(CCmdUI* pUI);
    afx_msg void OnUpdateInfo2(CCmdUI* pUI);
    afx_msg void OnUpdateInfo3(CCmdUI* pUI);
    
    afx_msg LONG OnTabAdded( UINT wParam, LONG lParam);
    afx_msg LONG OnTabDeleted( UINT wParam, LONG lParam);

	DECLARE_MESSAGE_MAP()
};

extern CMainFrame* pMainWnd;

/////////////////////////////////////////////////////////////////////////////
