/***************************************************************************
*  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
*  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
*                                                                         *
*  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
*  Chastain, Michael Quan, and Mitchell Tse.                              *
*                                                                         *
*  In order to use any part of this Merc Diku Mud, you must comply with   *
*  both the original Diku license in 'license.doc' as well the Merc       *
*  license in 'license.txt'.  In particular, you may not remove either of *
*  these copyright notices.                                               *
*                                                                         *
*  Much time and thought has gone into this software and you are          *
*  benefitting.  We hope that you share your changes too.  What goes      *
*  around, comes around.                                                  *
*                                                                         *
*  Cleaned up and generally made sparklier by Archon of Vampire Wars.     *
*                                                                         *
***************************************************************************/



/*
* Accommodate old non-Ansi compilers.
*/
#if defined(TRADITIONAL)
#define const
#define args( list )       ( )
#define DECLARE_DO_FUN( fun )    void fun( )
#define DECLARE_SPEC_FUN( fun )     bool fun( )
#define DECLARE_SPELL_FUN( fun ) void fun( )
#else
#define args( list )       list
#define DECLARE_DO_FUN( fun )    DO_FUN    fun
#define DECLARE_SPEC_FUN( fun )     SPEC_FUN  fun
#define DECLARE_SPELL_FUN( fun ) SPELL_FUN fun
#endif

/*
* Short scalar types.
* Diavolo reports AIX compiler has bugs with short types.
*/
#if   !defined(FALSE)
#define FALSE   0
#endif

#if   !defined(TRUE)
#define TRUE    1
#endif

#if   defined(_AIX)
#if   !defined(const)
#define const
#endif
typedef int          sh_int;
typedef int          bool;
#define unix
#else
typedef short int     sh_int;
typedef unsigned char         bool;
#endif



/*
* Structure types.
*/
typedef struct affect_data    AFFECT_DATA;
typedef struct area_data      AREA_DATA;
typedef struct ban_data    BAN_DATA;
typedef struct char_data      CHAR_DATA;
typedef struct descriptor_data      DESCRIPTOR_DATA;
typedef struct exit_data      EXIT_DATA;
typedef struct extra_descr_data  EXTRA_DESCR_DATA;
typedef struct help_data      HELP_DATA;
typedef struct kill_data      KILL_DATA;
typedef struct mob_index_data    MOB_INDEX_DATA;
typedef struct note_data      NOTE_DATA;
typedef struct obj_data    OBJ_DATA;
typedef struct obj_index_data    OBJ_INDEX_DATA;
typedef struct pc_data        PC_DATA;
typedef struct reset_data     RESET_DATA;
typedef struct room_index_data      ROOM_INDEX_DATA;
typedef struct shop_data      SHOP_DATA;
typedef struct time_info_data    TIME_INFO_DATA;
typedef struct weather_data      WEATHER_DATA;
typedef struct  clan_info               CLAN_INFO;
typedef struct league_info       LEAGUE_INFO;

/*
* Function types.
*/
typedef  void DO_FUN args( ( CHAR_DATA *ch, char *argument ) );
typedef bool SPEC_FUN   args( ( CHAR_DATA *ch ) );
typedef void SPELL_FUN  args( ( int sn, int level, CHAR_DATA *ch, void *vo ) );



/*
* String and memory management parameters.
*/
#define  MAX_KEY_HASH       1024
#define MAX_STRING_LENGTH  4096 
#define MAX_INPUT_LENGTH   160 
#define MAX_PLAYERS        10


/*
* Game parameters.
* Increase the max'es if you add more of something.
* Adjust the pulse numbers to suit yourself.
*/
#define TELL_HISTORY_SIZE  10
#define MAX_SKILL          150
#define MAX_CLASS          4
#define MAX_LEVEL          9
#define NO_WATCH           9
#define LEVEL_HERO         (MAX_LEVEL - 6)
#define LEVEL_IMMORTAL     (MAX_LEVEL - 5)
#define LEVEL_JUSTICAR     (MAX_LEVEL - 5)
#define LEVEL_SEER         (MAX_LEVEL - 3)
#define LEVEL_JUDGE        (MAX_LEVEL - 2)
#define LEVEL_ORACLE       (MAX_LEVEL - 2)
#define LEVEL_GOD          (MAX_LEVEL - 1)
#define LEVEL_JOKER         MAX_LEVEL
#define LEVEL_CODER         MAX_LEVEL

#define PULSE_PER_SECOND    4
#define PULSE_VIOLENCE    ( 3 * PULSE_PER_SECOND)
#define PULSE_MOBILE      ( 4 * PULSE_PER_SECOND)
#define PULSE_TICK        ( 30 * PULSE_PER_SECOND)
#define PULSE_AREA        ( 60 * PULSE_PER_SECOND)
 

#define MAX_CLAN     	   10
#define CLAN_BRUJAH        1
#define CLAN_MALKAVIAN     2 
#define CLAN_VENTRUE  	   3
#define CLAN_TREMERE  	   4
#define CLAN_GANGREL       5
#define CLAN_TOREADOR      6
#define CLAN_NOSFERATU     7
#define CLAN_ASSAMITE      8

/*
* Clan info structure.
*/
struct clan_info
{
    long members;
    int pkills[MAX_CLAN];
    int pkilled[MAX_CLAN];
    long mkills;
    int mkilled;
    int pkillstotal;
    int pkilledtotal;
};

struct league_info
{
    char* name;
    int Pk;
    int Pd;
    long Mk;
    int Md;
};

/*
* Site ban structure.
*/
struct   ban_data
{
    BAN_DATA * next;
    char *  name;
};



/*
* Time and weather stuff.
*/
#define SUN_DARK         0
#define SUN_RISE         1
#define SUN_LIGHT        2
#define SUN_SET          3

#define SKY_CLOUDLESS    0
#define SKY_CLOUDY       1
#define SKY_RAINING      2
#define SKY_LIGHTNING    3

struct   time_info_data
{
    int hour;
    int day;
    int month;
    int year;
};

struct   weather_data
{
    int mmhg;
    int change;
    int sky;
    int sunlight;
};



/*
* Connected state for a channel.
*/
#define CON_PLAYING               0
#define CON_GET_NAME              1
#define CON_GET_OLD_PASSWORD      2
#define CON_CONFIRM_NEW_NAME      3
#define CON_GET_NEW_PASSWORD      4
#define CON_CONFIRM_NEW_PASSWORD  5
#define CON_GET_NEW_SEX           6
#define CON_GET_NEW_CLASS         7
#define CON_READ_MOTD             8
#define CON_NOT_PLAYING           9



/*
* Descriptor (channel) structure.
*/
struct   descriptor_data
{
    DESCRIPTOR_DATA * next;
    DESCRIPTOR_DATA * snoop_by;
    CHAR_DATA * character;
    CHAR_DATA * original;
    char * host;
    sh_int descriptor;
    sh_int connected;
    bool fcommand;
    char inbuf   [4 * MAX_INPUT_LENGTH];
    char incomm  [MAX_INPUT_LENGTH];
    char inlast  [MAX_INPUT_LENGTH];
    int repeat;
    char * outbuf;
    int outsize;
    int outtop;
    int host_ip;
    time_t connect_time;
};

/*
* Attribute bonus structures.
*/
struct   str_app_type
{
    sh_int  tohit;
    sh_int  todam;
    sh_int  carry;
    sh_int  wield;
};

struct   int_app_type
{
    sh_int  learn;
};

struct   wis_app_type
{
    sh_int  practice;
};

struct   dex_app_type
{
    sh_int  defensive;
};

struct   con_app_type
{
    sh_int  hitp;
    sh_int  shock;
};

/*
* TO types for act.
*/
#define TO_ROOM      0
#define TO_NOTVICT   1
#define TO_VICT      2
#define TO_CHAR      3


/*
* Help table types.
*/
struct   help_data
{
    HELP_DATA *   next;
    sh_int  level;
    char *  keyword;
    char *  text;
};



/*
* Shop types.
*/
#define MAX_TRADE  5

struct   shop_data
{
    SHOP_DATA *   next;           /* Next shop in list    */
    long    keeper;               /* Vnum of shop keeper mob */
    long    buy_type [MAX_TRADE]; /* Item types shop will buy   */
    sh_int  profit_buy;           /* Cost multiplier for buying */
    sh_int  profit_sell;          /* Cost multiplier for selling   */
    sh_int  open_hour;            /* First opening hour      */
    sh_int  close_hour;           /* First closing hour      */
};



/*
* Per-class stuff.
*/
struct   class_type
{
    char    who_name [4];  /* Three-letter name for 'who'   */
    sh_int  attr_prime;    /* Prime attribute      */
    sh_int  weapon;        /* First weapon         */
    sh_int  guild;         /* Vnum of guild room      */
    sh_int  skill_adept;   /* Maximum skill level     */
    sh_int  thac0_00;      /* Thac0 for level  0      */
    sh_int  thac0_32;      /* Thac0 for level 32      */
    sh_int  hp_min;        /* Min hp gained on leveling  */
    sh_int  hp_max;        /* Max hp gained on leveling  */
    bool fMana;            /* Class gains mana on level  */
};

/*
* Data structure for notes.
*/
struct   note_data
{
    NOTE_DATA *   next;
    char *  sender;
    char *  date;
    char *  to_list;
    char *  subject;
    char *  text;
};



/*
* An affect.
*/
struct   affect_data
{
    AFFECT_DATA * next;
    sh_int     type;
    sh_int     duration;
    sh_int     location;
    sh_int     modifier;
    int        bitvector;
};



/*
* A kill structure (indexed by level).
*/
struct   kill_data
{
    sh_int     number;
    sh_int     killed;
};



/***************************************************************************
*                                                                         *
*                   VALUES OF INTEREST TO AREA BUILDERS                   *
*                   (Start of section ... start here)                     *
*                                                                         *
***************************************************************************/

/*
* Well known mob virtual numbers.
* Defined in #MOBILES.
*/
#define MOB_VNUM_CITYGUARD    3060
#define MOB_VNUM_VAMPIRE      3404

/*
* Immunities, for players.  KaVir.
*/
#define IMM_SLASH       1       /* Resistance to slash, slice.      */
#define IMM_STAB        2       /* Resistance to stab, pierce.      */
#define IMM_SMASH       4       /* Resistance to blast, pound, crush.  */
#define IMM_ANIMAL      8       /* Resistance to bite, claw.     */
#define IMM_MISC        16      /* Resistance to grep, suck, whip.  */
#define IMM_CHARM       32      /* Immune to charm spell.     */
#define IMM_HEAT        64      /* Immune to fire/heat spells.      */
#define IMM_COLD        128     /* Immune to frost/cold spells.     */
#define IMM_LIGHTNING   256     /* Immune to lightning spells.      */
#define IMM_ACID        512     /* Immune to acid spells.     */
#define IMM_SUMMON      1024    /* Immune to being summoned.     */
#define IMM_VOODOO      2048    /* Immune to voodoo magic.    */
#define IMM_VAMPIRE     4096    /* Allow yourself to become a vampire. */
#define IMM_STAKE       8192    /* Immune to being staked (vamps only).   */
#define IMM_SUNLIGHT    16384   /* Immune to sunlight (vamps only). */
#define IMM_SHIELDED    32768   /* For Obfuscate. Block scry, etc.   */
#define IMM_HURL        65536   /* Cannot be hurled.        */
#define IMM_BACKSTAB    131072  /* Cannot be backstabbed.      */
#define IMM_KICK        262144  /* Cannot be kicked.        */
#define IMM_DISARM      524288  /* Cannot be disarmed.         */
#define IMM_STEAL       1048576 /* Cannot have stuff stolen.      */
#define IMM_SLEEP       2097152 /* Immune to sleep spell.      */
#define IMM_DRAIN       4194304 /* Immune to energy drain.     */

/*
* ACT bits for mobs.
* Used in #MOBILES.
*/
#define ACT_IS_NPC      1     /* Auto set for mobs */
#define ACT_SENTINEL    2     /* Stays in one room */
#define ACT_SCAVENGER   4     /* Picks up objects  */
#define ACT_AGGRESSIVE  32    /* Attacks PC's      */
#define ACT_STAY_AREA   64    /* Won't leave area  */
#define ACT_WIMPY       128   /* Flees when hurt   */
#define ACT_PET         256   /* Auto set for pets */
#define ACT_TRAIN       512   /* Can train PC's */
#define ACT_PRACTICE    1024  /* Can practice PC's */
#define ACT_MOUNT       2048  /* Can be mounted */
#define ACT_IMMKICK     4096  /* cannot be kicked */
#define ACT_BANKER      8192  /* UNUSED */
#define ACT_IMMBLIND    16384 /* cannot be blinded */

/*
* Bits for 'affected_by'.
* Used in #MOBILES.
*/
#define AFF_BLIND          1
#define AFF_INVISIBLE      2
#define AFF_DETECT_EVIL    4
#define AFF_DETECT_INVIS   8
#define AFF_DETECT_MAGIC   16
#define AFF_DETECT_HIDDEN  32
#define AFF_SHADOWPLANE    64      /* Creatures in shadow plane - KaVir */
#define AFF_SANCTUARY      128
#define AFF_FAERIE_FIRE    256
#define AFF_INFRARED       512
#define AFF_CURSE          1024
#define AFF_FLAMING        2048    /* For burning creatures - KaVir */
#define AFF_POISON         4096
#define AFF_PROTECT        8192
#define AFF_ETHEREAL       16384   /* For ethereal creatures - KaVir */
#define AFF_SNEAK          32768
#define AFF_HIDE           65536
#define AFF_SLEEP          131072
#define AFF_CHARM          262144
#define AFF_FLYING         524288
#define AFF_PASS_DOOR      1048576
#define AFF_POLYMORPH      2097152 /* For polymorphed creatures - KaVir */
#define AFF_SHADOWSIGHT    4194304 /* Can see between planes - KaVir */
#define AFF_TRACKING       8388608  

/*
* Bits for 'itemaffect'.
* Used in #MOBILES.
*/
#define ITEMA_SHOCKSHIELD        1
#define ITEMA_FIRESHIELD         2
#define ITEMA_ICESHIELD          4
#define ITEMA_ACIDSHIELD         8


/* Colour scale macros - added 12th Aug 1995 by Calamar */

#define NO_COLOUR ""          /* Blank       */
#define GREY      "[0;1;30m" /* Dark Grey   */
#define D_RED     "[0;0;31m" /* Dark Red    */
#define L_RED     "[0;1;31m" /* Light Red   */
#define D_GREEN   "[0;0;32m" /* Dark Green  */
#define L_GREEN   "[0;1;32m" /* Light Green */
#define BROWN     "[0;0;33m" /* Brown       */
#define YELLOW    "[0;1;33m" /* Yellow      */
#define D_BLUE    "[0;0;34m" /* Dark Blue   */
#define L_BLUE    "[0;1;34m" /* Light Blue  */
#define MAGENTA   "[0;0;35m" /* Magenta     */
#define PINK      "[0;1;35m" /* Pink        */
#define D_CYAN    "[0;0;36m" /* Dark Cyan   */
#define L_CYAN    "[0;1;36m" /* Light Cyan  */
#define NORMAL    "[0;0;37m" /* Light Grey  */
#define WHITE     "[0;0;38m" /* White */

#define ADD_COLOUR(_player,_str,_col,_str_size) \
{ \
	if (!IS_NPC(_player) && IS_SET(_player->act, PLR_ANSI)) \
	{ \
	    int to_move = strlen(_str)+1; \
	    int to_insert = strlen(_col); \
	    if ( to_move + to_insert > _str_size ) \
	    { \
	    	to_insert = _str_size - to_move; \
	    } \
		memmove( _str + to_insert, _str, to_move );          /* move the string along */\
		memcpy( _str, _col, to_insert );                     /* slip the colour code in before it */\
		strncat( _str, NORMAL, _str_size - strlen(_str));    /* append the normal colour code */\
	} \
} \

#define SCALE_COLS 4

#define COL_SCALE(_swh_str,_swh_ch,_swh_curr,_swh_max,_swh_str_size) \
	ADD_COLOUR(_swh_ch, _swh_str, \
	(_swh_curr < 1) ? L_RED : \
	(_swh_curr < _swh_max) ? \
	scale[(SCALE_COLS * _swh_curr) / ((_swh_max > 0) \
	? _swh_max : 1)] : L_CYAN, _swh_str_size)

extern char *scale[SCALE_COLS];

/*
* Bits for 'vampire'.
* Used for player vampires.
*
* NO NO NO, this is all wrong, going to have to change this.. -Archon.
*/
#define VAM_FANGS          1
#define VAM_CLAWS          2
#define VAM_NIGHTSIGHT     4
#define VAM_FLYING         8      /* For flying creatures */
#define VAM_SONIC          16     /* For creatures with full detect */
#define VAM_CHANGED        32     /* Changed using a vampire power */
#define VAM_PROTEAN        64     /* Claws, nightsight, and change */
#define VAM_CELERITY       128    /* 66%/33% chance 1/2 extra attacks */
#define VAM_FORTITUDE      256    /* 5 hp less per hit taken */
#define VAM_POTENCE        512    /* Deal out 1.5 times normal damage */
#define VAM_OBFUSCATE      1024   /* Disguise and invis */
#define VAM_AUSPEX         2048   /* Truesight, etc */
#define VAM_OBTENEBRATION  4096   /* Shadowplane/sight and shadowbody */
#define VAM_SERPENTIS      8192   /* Eyes/serpent, heart/darkness, etc */
#define VAM_DISGUISED      16384  /* For the Obfuscate disguise ability */
#define VAM_MORTAL         32768  /* For Obfuscate mortal ability. */
#define VAM_DOMINATE       65536  /* Evileye, command */
#define VAM_EVILEYE        131072 /* Evileye, command */


/*
* Bits for 'polymorph'.
* Used for players.
*/
#define POLY_BAT        1
#define POLY_WOLF       2
#define POLY_MIST       4
#define POLY_SERPENT    8



/*
* Mounts
*/
#define IS_ON_FOOT    0
#define IS_MOUNT      1
#define IS_RIDING     2
#define IS_CARRIED    4
#define IS_CARRYING   8




/*
* Sex.
* Used in #MOBILES.
*/
#define SEX_NEUTRAL   0
#define SEX_MALE      1
#define SEX_FEMALE    2


/*
* Well known object virtual numbers.
* Defined in #OBJECTS.
*
* Why we need all these defines of vnums is beyond me,
* So they will gradually be phased out -Archon.
*/
#define OBJ_VNUM_MONEY_ONE      2
#define OBJ_VNUM_MONEY_SOME     3
#define OBJ_VNUM_CORPSE_NPC     10
#define OBJ_VNUM_CORPSE_PC      11
#define OBJ_VNUM_SEVERED_HEAD   12
#define OBJ_VNUM_TORN_HEART     13
#define OBJ_VNUM_SLICED_ARM     14
#define OBJ_VNUM_SLICED_LEG     15
#define OBJ_VNUM_FINAL_TURD     16
#define OBJ_VNUM_MUSHROOM       20
#define OBJ_VNUM_LIGHT_BALL     21
#define OBJ_VNUM_SPRING         22
#define OBJ_VNUM_BLOOD_SPRING   23
#define OBJ_VNUM_SCHOOL_MACE    3700
#define OBJ_VNUM_SCHOOL_DAGGER  3701
#define OBJ_VNUM_SCHOOL_SWORD   3702
#define OBJ_VNUM_SCHOOL_VEST    3703
#define OBJ_VNUM_SCHOOL_SHIELD  3704
#define OBJ_VNUM_SCHOOL_BANNER  3716

/* For KaVir's stuff */
#define OBJ_VNUM_SOULBLADE         30000
#define OBJ_VNUM_PORTAL            30001
#define OBJ_VNUM_EGG               30002
#define OBJ_VNUM_EMPTY_EGG         30003
#define OBJ_VNUM_SPILLED_ENTRAILS  30004
#define OBJ_VNUM_QUIVERING_BRAIN   30005
#define OBJ_VNUM_SQUIDGY_EYEBALL   30006
#define OBJ_VNUM_SPILT_BLOOD       30007
#define OBJ_VNUM_VOODOO_DOLL       30010
#define OBJ_VNUM_RIPPED_FACE       30012
#define OBJ_VNUM_TORN_WINDPIPE     30013
#define OBJ_VNUM_CRACKED_HEAD      30014
#define OBJ_VNUM_SLICED_EAR        30025
#define OBJ_VNUM_SLICED_NOSE       30026
#define OBJ_VNUM_KNOCKED_TOOTH     30027
#define OBJ_VNUM_TORN_TONGUE       30028
#define OBJ_VNUM_SEVERED_HAND      30029
#define OBJ_VNUM_SEVERED_FOOT      30030
#define OBJ_VNUM_SEVERED_THUMB     30031
#define OBJ_VNUM_SEVERED_INDEX     30032
#define OBJ_VNUM_SEVERED_MIDDLE    30033
#define OBJ_VNUM_SEVERED_RING      30034
#define OBJ_VNUM_SEVERED_LITTLE    30035
#define OBJ_VNUM_SEVERED_TOE       30036
#define OBJ_VNUM_PROTOPLASM        30037
#define OBJ_VNUM_QUESTCARD         30039
#define OBJ_VNUM_QUESTMACHINE      30040
#define MOB_VNUM_GUARDIAN          30001
#define MOB_VNUM_MOUNT             30006
#define MOB_VNUM_CLONE             30008


/*
* Item types.
* Used in #OBJECTS.
*/
#define ITEM_LIGHT         1
#define ITEM_SCROLL        2
#define ITEM_WAND          3
#define ITEM_STAFF         4
#define ITEM_WEAPON        5
#define ITEM_TREASURE      8
#define ITEM_ARMOR         9
#define ITEM_POTION        10
#define ITEM_FURNITURE     12
#define ITEM_TRASH         13
#define ITEM_CONTAINER     15
#define ITEM_DRINK_CON     17
#define ITEM_KEY           18
#define ITEM_FOOD          19
#define ITEM_MONEY         20
#define ITEM_BOAT          22
#define ITEM_CORPSE_NPC    23
#define ITEM_CORPSE_PC     24
#define ITEM_FOUNTAIN      25
#define ITEM_PILL          26
#define ITEM_PORTAL        27
#define ITEM_EGG           28
#define ITEM_VOODOO        29
#define ITEM_STAKE         30
#define ITEM_MISSILE       31 /* Ammo vnum, cur, max, type */
#define ITEM_AMMO          32 /* Accuracy, dam min, dam max, type */
#define ITEM_QUEST         33
#define ITEM_QUESTCARD     34
#define ITEM_QUESTMACHINE  35
#define ITEM_BOMB          36


/*
* Extra flags.
* Used in #OBJECTS.
*/
#define ITEM_GLOW           1
#define ITEM_HUM            2
#define ITEM_THROWN         4
#define ITEM_KEEP           8
#define ITEM_VANISH         16
#define ITEM_INVIS          32
#define ITEM_MAGIC          64
#define ITEM_NODROP         128
#define ITEM_BLESS          256
#define ITEM_ANTI_GOOD      512
#define ITEM_ANTI_EVIL      1024
#define ITEM_ANTI_NEUTRAL   2048
#define ITEM_NOREMOVE       4096
#define ITEM_INVENTORY      8192
#define ITEM_LOYAL          16384
#define ITEM_SHADOWPLANE    32768
#define ITEM_SILVER         65536
#define ITEM_NOQUESTCARD    131072
#define ITEM_QUESTITEM      262144
#define ITEM_CLANITEM       524288
#define ITEM_AUTOCLAIM      1048576
#define ITEM_SILENTVANISH   2097152

/*
* Wear flags.
* Used in #OBJECTS.
*/
#define ITEM_TAKE          1
#define ITEM_WEAR_FINGER   2
#define ITEM_WEAR_NECK     4
#define ITEM_WEAR_BODY     8
#define ITEM_WEAR_HEAD     16
#define ITEM_WEAR_LEGS     32
#define ITEM_WEAR_FEET     64
#define ITEM_WEAR_HANDS    128 
#define ITEM_WEAR_ARMS     256
#define ITEM_WEAR_SHIELD   512
#define ITEM_WEAR_ABOUT    1024 
#define ITEM_WEAR_WAIST    2048
#define ITEM_WEAR_WRIST    4096
#define ITEM_WIELD         8192
#define ITEM_HOLD          16384
#define ITEM_WEAR_FACE     32768


/*
* Special types.
* Used in #OBJECTS for special items - KaVir.
*/
#define SITEM_ACTIVATE     1
#define SITEM_TWIST        2
#define SITEM_PRESS        4
#define SITEM_PULL         8
#define SITEM_TARGET       16
#define SITEM_SPELL        32
#define SITEM_TRANSPORTER  64
#define SITEM_TELEPORTER   128
#define SITEM_DELAY1       256
#define SITEM_DELAY2       512
#define SITEM_OBJECT       1024
#define SITEM_MOBILE       2048
#define SITEM_ACTION       4096
#define SITEM_MORPH        8192

/*
* Apply types (for quest affects).
* Used in #OBJECTS.
*/                      
#define QUEST_STR         1
#define QUEST_DEX         2
#define QUEST_INT         4
#define QUEST_WIS         8 
#define QUEST_CON         16
#define QUEST_HITROLL     32
#define QUEST_DAMROLL     64
#define QUEST_HIT         128
#define QUEST_MANA        256
#define QUEST_MOVE        512
#define QUEST_AC          1024
#define QUEST_NAME        2048
#define QUEST_SHORT       4096
#define QUEST_LONG        8192
#define QUEST_FREENAME    16384
#define QUEST_ENCHANTED   32768
#define QUEST_SPELLPROOF  65536
#define QUEST_INDEST      131072


/*
* Apply types (for affects).
* Used in #OBJECTS.
*/
#define APPLY_NONE            0
#define APPLY_STR             1
#define APPLY_DEX             2
#define APPLY_INT             3
#define APPLY_WIS             4
#define APPLY_CON             5
#define APPLY_SEX             6
#define APPLY_CLASS           7
#define APPLY_LEVEL           8
#define APPLY_AGE             9
#define APPLY_HEIGHT          10
#define APPLY_WEIGHT          11
#define APPLY_MANA            12
#define APPLY_HIT             13
#define APPLY_MOVE            14
#define APPLY_GOLD            15
#define APPLY_EXP             16
#define APPLY_AC              17
#define APPLY_HITROLL         18
#define APPLY_DAMROLL         19
#define APPLY_SAVING_PARA     20
#define APPLY_SAVING_ROD      21
#define APPLY_SAVING_PETRI    22
#define APPLY_SAVING_BREATH   23
#define APPLY_SAVING_SPELL    24

/*
* Values for containers (value[1]).
* Used in #OBJECTS.
*/
#define CONT_CLOSEABLE  1
#define CONT_PICKPROOF  2
#define CONT_CLOSED     4
#define CONT_LOCKED     8



/*
* Well known room virtual numbers.
* Defined in #ROOMS.
*/
#define ROOM_VNUM_LIMBO                  2
#define ROOM_VNUM_CHAT                   1200
#define ROOM_VNUM_TEMPLE                 3001
#define ROOM_VNUM_ALTAR                  3054
#define ROOM_VNUM_SCHOOL                 800
#define ROOM_VNUM_HELL                   30000
#define ROOM_VNUM_CRYPT                  30001
#define ROOM_VNUM_DISCONNECTION          30002
#define ROOM_VNUM_IN_OBJECT              30008
#define ROOM_VNUM_BRUJAH_DONROOM         454
#define ROOM_VNUM_GANGREL_DONROOM        487
#define ROOM_VNUM_VENTRUE_DONROOM        410
#define ROOM_VNUM_MALKAVIAN_DONROOM      465
#define ROOM_VNUM_TREMERE_DONROOM        443
#define ROOM_VNUM_NOSFERATU_DONROOM      432
#define ROOM_VNUM_TOREADOR_DONROOM       476
#define ROOM_VNUM_CAPPADOCIAN_DONROOM    421
#define ROOM_VNUM_SABBAT_DONROOM         3207
#define ROOM_VNUM_DONATION_ROOM          3207


/*
* Room flags.
* Used in #ROOMS.
*/
#define ROOM_DARK              1
#define ROOM_SACRED            2
#define ROOM_NO_MOB            4
#define ROOM_INDOORS           8
#define ROOM_QUIET             16
#define ROOM_NO_SHADOWPLANE    32
#define ROOM_NO_SPELL          64
#define ROOM_NO_CLAIMORCALL    128
#define ROOM_BANK              256
#define ROOM_PRIVATE           512
#define ROOM_SAFE              1024
#define ROOM_SOLITARY          2048
#define ROOM_PET_SHOP          4096
#define ROOM_NO_RECALL         8192
#define ROOM_CONE_OF_SILENCE   16384
#define ROOM_NO_TELEPORT       32768
#define ROOM_NO_MIST           65536
#define ROOM_NO_TRANSPORT      131072
#define ROOM_NO_ESCAPE         262144
#define ROOM_NO_HOME           524288
#define ROOM_NO_SUMMON         1048576


/*
* Room text flags (KaVir).
* Used in #ROOMS.
*/
#define RT_LIGHTS      1 /* Toggles lights on/off */
#define RT_SAY         2       /* Use this if no others powers */
#define RT_ENTER       4
#define RT_CAST        8
#define RT_THROWOUT    16      /* Erm...can't remember ;) */
#define RT_OBJECT      32      /* Creates an object */
#define RT_MOBILE      64      /* Creates a mobile */
#define RT_LIGHT       128     /* Lights on ONLY */
#define RT_DARK        256     /* Lights off ONLY */
#define RT_OPEN_LIFT   512     /* Open lift */
#define RT_CLOSE_LIFT  1024    /* Close lift */
#define RT_MOVE_LIFT   2048    /* Move lift */
#define RT_SPELL       4096    /* Cast a spell */
#define RT_PORTAL      8192    /* Creates a one-way portal */
#define RT_TELEPORT    16384   /* Teleport player to room */
#define RT_ACTION      32768
#define RT_BLANK_1     65536
#define RT_BLANK_2     131072
#define RT_RETURN      1048576 /* Perform once */
#define RT_PERSONAL    2097152 /* Only shows message to char */
#define RT_TIMER       4194304 /* Sets object timer to 1 tick */
#define RT_GODPASS     8388608 /* Only works if player flagged with godpass */


/*
* Directions.
* Used in #ROOMS.
*/
#define DIR_NORTH          0
#define DIR_EAST           1
#define DIR_SOUTH          2
#define DIR_WEST           3
#define DIR_UP             4
#define DIR_DOWN           5



/*
* Exit flags.
* Used in #ROOMS.
*/
#define EX_ISDOOR          1
#define EX_CLOSED          2
#define EX_LOCKED          4
#define EX_BASHED	   8
#define EX_BASHPROOF	   16
#define EX_PICKPROOF       32
#define EX_PASSPROOF	   64


/*
* Sector types.
* Used in #ROOMS.
*/
#define SECT_INSIDE          0
#define SECT_CITY            1
#define SECT_FIELD           2
#define SECT_FOREST          3
#define SECT_HILLS           4
#define SECT_MOUNTAIN        5
#define SECT_WATER_SWIM      6
#define SECT_WATER_NOSWIM    7
#define SECT_UNUSED          8
#define SECT_AIR             9
#define SECT_DESERT         10
#define SECT_MAX            11
#define SECT_BRUJAH         12
#define SECT_TZIMISCE       13
#define SECT_MALKAVIAN      14
#define SECT_VENTRUE        15
#define SECT_GANGREL        16
#define SECT_TOREADOR       17
#define SECT_NOSFERATU      18
#define SECT_CAITIFF        19
#define SECT_SABBAT         20
#define SECT_CAPPADOCIAN    21


/*
* Equipment wear locations.
* Used in #RESETS.
*/
#define WEAR_NONE         -1
#define WEAR_LIGHT        0
#define WEAR_FINGER_L     1
#define WEAR_FINGER_R     2
#define WEAR_NECK_1       3
#define WEAR_NECK_2       4
#define WEAR_BODY         5
#define WEAR_HEAD         6
#define WEAR_LEGS         7
#define WEAR_FEET         8
#define WEAR_HANDS        9
#define WEAR_ARMS         10
#define WEAR_SHIELD       11
#define WEAR_ABOUT        12
#define WEAR_WAIST        13
#define WEAR_WRIST_L      14
#define WEAR_WRIST_R      15
#define WEAR_WIELD        16
#define WEAR_HOLD         17
#define WEAR_FACE         18
#define WEAR_SCABBARD_L   19
#define WEAR_SCABBARD_R   20
#define MAX_WEAR          21


/*
* Locations for damage.
*/
#define LOC_HEAD           0
#define LOC_BODY           1
#define LOC_ARM_L          2
#define LOC_ARM_R          3
#define LOC_LEG_L          4
#define LOC_LEG_R          5

/*
* For Head
*/
#define LOST_EYE_L      1
#define LOST_EYE_R      2
#define LOST_EAR_L      4
#define LOST_EAR_R      8
#define LOST_NOSE       16
#define BROKEN_NOSE     32
#define BROKEN_JAW      64
#define BROKEN_SKULL    128
#define LOST_HEAD       256
#define LOST_TOOTH_1    512  /* These should be added..... */
#define LOST_TOOTH_2    1024 /* ...together to caculate... */
#define LOST_TOOTH_4    2048 /* ...the total number of.... */
#define LOST_TOOTH_8    4096 /* ...teeth lost.  Total..... */
#define LOST_TOOTH_16   8192 /* ...possible is 31 teeth.   */
#define LOST_TONGUE     16384

/*
* For Body
*/
#define BROKEN_RIBS_1   1 /* Remember there are a total */
#define BROKEN_RIBS_2   2 /* of 12 pairs of ribs in the */
#define BROKEN_RIBS_4   4 /* human body, so not all of  */
#define BROKEN_RIBS_8   8 /* these bits should be set   */
#define BROKEN_RIBS_16  16 /* at the same time.          */
#define BROKEN_SPINE    32
#define BROKEN_NECK     64
#define CUT_THROAT      128
#define TIED_UP         256
#define GAGGED          512
#define BLINDFOLDED     1024

/*
* For Arms
*/
#define BROKEN_ARM         1
#define LOST_ARM           2
#define LOST_HAND          4
#define LOST_FINGER_I      8 /* Index finger */
#define LOST_FINGER_M      16 /* Middle finger */
#define LOST_FINGER_R      32 /* Ring finger */
#define LOST_FINGER_L      64 /* Little finger */
#define LOST_THUMB         128
#define BROKEN_FINGER_I    256 /* Index finger */
#define BROKEN_FINGER_M    512 /* Middle finger */
#define BROKEN_FINGER_R    1024 /* Ring finger */
#define BROKEN_FINGER_L    2048 /* Little finger */
#define BROKEN_THUMB       4096

/*
* For Legs
*/
#define BROKEN_LEG      1
#define LOST_LEG        2
#define LOST_FOOT       4
#define LOST_TOE_A      8
#define LOST_TOE_B      16
#define LOST_TOE_C      32
#define LOST_TOE_D      64   /* Smallest toe */
#define LOST_TOE_BIG    128
#define BROKEN_TOE_A    256
#define BROKEN_TOE_B    512
#define BROKEN_TOE_C    1024
#define BROKEN_TOE_D    2048 /* Smallest toe */
#define BROKEN_TOE_BIG  4096

/*
* For Bleeding
*/
#define BLEEDING_HEAD           1
#define BLEEDING_THROAT         2
#define BLEEDING_ARM_L          4
#define BLEEDING_ARM_R          8
#define BLEEDING_HAND_L         16
#define BLEEDING_HAND_R         32
#define BLEEDING_LEG_L          64
#define BLEEDING_LEG_R          128
#define BLEEDING_FOOT_L         256
#define BLEEDING_FOOT_R         512


/*
* For Spec powers on players
*/
#define EYE_SPELL         1 /* Spell when they look at you */
#define EYE_SELFACTION    2 /* You do action when they look */
#define EYE_ACTION        4 /* Others do action when they look */




/***************************************************************************
*                                                                         *
*                   VALUES OF INTEREST TO AREA BUILDERS                   *
*                   (End of this section ... stop here)                   *
*                                                                         *
***************************************************************************/

/*
* Conditions.
*/
#define COND_DRUNK     0
#define COND_FULL      1
#define COND_THIRST    2



/*
* Positions.
*/
#define POS_DEAD         0
#define POS_MORTAL       1
#define POS_INCAP        2
#define POS_STUNNED      3
#define POS_SLEEPING     4
#define POS_RESTING      5
#define POS_FIGHTING     6
#define POS_STANDING     7



/*
* ACT bits for players.
*/
#define PLR_IS_NPC       1     /* Don't EVER set.   */
#define PLR_BOUGHT_PET   2
#define PLR_GODPASS      4
#define PLR_AUTOEXIT     8
#define PLR_AUTOLOOT     16
#define PLR_AUTOSAC      32
#define PLR_BLANK        64
#define PLR_BRIEF        128
#define PLR_FIGHT        256
#define PLR_COMBINE      512
#define PLR_PROMPT       1024
#define PLR_TELNET_GA    2048
#define PLR_HOLYLIGHT    4096
#define PLR_WIZINVIS     8192
#define PLR_ANSI         16384
#define PLR_SILENCE      32768
#define PLR_NO_EMOTE     65536
#define PLR_SABBAT       131072
#define PLR_NO_TELL      262144
#define PLR_LOG          524288
#define PLR_DENY         1048576
#define PLR_FREEZE       2097152
#define PLR_THIEF        4194304
#define PLR_KILLER       8388608
#define PLR_GODLESS      16777216
#define PLR_WATCHER      33554432
#define PLR_VAMPIRE      67108864
#define PLR_FIGHT2       134217728
#define PLR_NOTRANS      268435456
#define PLR_NOQUIT       536870912



/*
* EXTRA bits for players. (KaVir)
*/
#define EXTRA_SIRE            1
#define EXTRA_PRINCE          2
#define EXTRA_TRUSTED         4
#define EXTRA_NEWPASS         8
#define EXTRA_OSWITCH        16
#define EXTRA_SWITCH         32
#define EXTRA_ORGYMEMBER     64
#define EXTRA_PERSONAL      128
#define EXTRA_BANNED        256


/*
* Stances for combat
*/
#define STANCE_NONE          -1
#define STANCE_NORMAL         0 
#define STANCE_VIPER          1
#define STANCE_CRANE          2
#define STANCE_FALCON         3
#define STANCE_MONGOOSE       4
#define STANCE_BULL           5
#define STANCE_SWALLOW        6
#define STANCE_COBRA          7
#define STANCE_LION           8
#define STANCE_GRIZZLIE       9
#define STANCE_PANTHER       10


/*
* Obsolete bits.
*/
#if 0
#define PLR_AUCTION      4       /* Obsolete */
#define PLR_CHAT         256     /* Obsolete */
#define PLR_NO_SHOUT     131072  /* Obsolete */
#endif



/*
* Channel bits.
*/
#define  CHANNEL_AUCTION    1
#define  CHANNEL_CHAT       2
#define  CHANNEL_HACKER     4
#define  CHANNEL_IMMTALK    8
#define  CHANNEL_MUSIC      16
#define  CHANNEL_QUESTION   32
#define  CHANNEL_SHOUT      64
#define  CHANNEL_YELL       128
#define  CHANNEL_VAMPTALK   256
#define  CHANNEL_IMMINFO    512
#define  CHANNEL_ORGY       1024
#define  CHANNEL_PERSONAL   2048
#define  CHANNEL_MCHAT      4096
#define  CHANNEL_NOSTALK    8192 
#define  CHANNEL_BRUTALK    16384
#define  CHANNEL_GANGTALK   32768
#define  CHANNEL_TREMTALK   65536
#define  CHANNEL_TORTALK    131072
#define  CHANNEL_CAPTALK    262144
#define  CHANNEL_MALKTALK   524288
#define  CHANNEL_VENTALK    1048576
#define  CHANNEL_JUSTITALK     2097152      
#define  CHANNEL_BID        4194304


/*
* Prototype for a mob.
* This is the in-memory version of #MOBILES.
*/
struct   mob_index_data
{
    MOB_INDEX_DATA * next;
    SPEC_FUN *    spec_fun;
    SHOP_DATA *      pShop;
    CHAR_DATA *      mount;
    char *     player_name;
    char *     short_descr;
    char *     long_descr;
    char *     description;
    char *     lord;
    char *     clan;
    char *     morph;
    char *     createtime;
    char *     lasttime;
    char *     lasthost;
    char *     powertype;
    char *     poweraction;
    char *     pload;
    sh_int     spectype;
    sh_int     specpower;
    sh_int     loc_hp   [7];
    long       vnum;
    sh_int     count;
    sh_int     killed;
    sh_int     sex;
    sh_int     mounted;
    long       home;
    sh_int     level;
    sh_int     exp_level;
    long       immune;
    int        polyaff;
    long       vampaff;
    int        itemaffect;
    long       vamppass;
    int        form;
    long       act;
    int        extra;
    long       affected_by;
    sh_int     alignment;
    sh_int     hitroll;     /* Unused */
    sh_int     ac;          /* Unused */
    sh_int     hitnodice;   /* Unused */
    sh_int     hitsizedice; 
    sh_int     hitplus;     
    sh_int     damnodice;   /* Unused */
    sh_int     damsizedice; /* Unused */
    sh_int     damplus;     /* Unused */
    int        gold;        /* Unused */
};   


/*
* One character (PC or NPC).
*/
struct   char_data
{
    CHAR_DATA *      next;
    CHAR_DATA *      next_in_room;
    CHAR_DATA *      master;
    CHAR_DATA *      leader;
    CHAR_DATA *      fighting;
    CHAR_DATA *      reply;
    CHAR_DATA *      mount;
    SPEC_FUN *    spec_fun;
    MOB_INDEX_DATA * pIndexData;
    DESCRIPTOR_DATA *   desc;
    AFFECT_DATA * affected;
    NOTE_DATA *      pnote;
    OBJ_DATA *    carrying;
    ROOM_INDEX_DATA *   in_room;
    ROOM_INDEX_DATA *   was_in_room;
    PC_DATA *     pcdata;
    char *     name;
    char *     short_descr;
    char *     long_descr;
    char *     description;
    char *     lord;
    char *     clan;
    char *     morph;
    char *     createtime;
    char *     lasttime;
    char *     lasthost;
    char *     poweraction;
    char *     powertype;
    char *     pload;
    CHAR_DATA *         hunting;
    sh_int     sex;
    sh_int     class;
    sh_int     race;
    long       immune;
    int        polyaff;
    long       vampaff;
    int        itemaffect;
    long       vamppass;
    int        form;
    sh_int     vampgen;
    sh_int     spectype;
    sh_int     specpower;
    sh_int     loc_hp   [7];
    sh_int     wpn   [13];
    sh_int     spl   [5];
    sh_int     cmbt  [8];
    sh_int     stance   [11];
    sh_int     beast;
    sh_int     mounted;
    long       home;
    sh_int     level;
    sh_int     exp_level;
    sh_int     trust;
    long       played;
    time_t     logon;
    time_t     save_time;
    sh_int     timer;
    sh_int     wait;
    sh_int     pkill;
    sh_int     pdeath;
    long       mkill;
    sh_int     mdeath;
    sh_int     hit;
    sh_int     max_hit;
    sh_int     mana;
    sh_int     max_mana;
    sh_int     move;
    sh_int     max_move;
    long       gold;
    long       bank;
    long       exp;
    long       act;
    int        extra;
    long       affected_by;
    sh_int     position;
    sh_int     practice;
    sh_int     carry_weight;
    sh_int     carry_number;
    sh_int     saving_throw;
    sh_int     alignment;
    sh_int     hitroll;
    sh_int     damroll;
    sh_int     armor;
    sh_int     wimpy;
    long       deaf;
    int        lagpenalty;
    int        host_ip;
    int        choke_dam_message;
};   

/*
* Data which only PC's have.
*/
struct   pc_data
{
    PC_DATA *     next;
    OBJ_DATA *    chobj;
    char *     pwd;
    char *     email;
    char *     hunting;
    char *     bamfin;
    char *     bamfout;
    char *     title;
    char *     tell_history [TELL_HISTORY_SIZE];
    sh_int     tell_history_pos;
    sh_int     perm_str;
    sh_int     perm_int;
    sh_int     perm_wis;
    sh_int     perm_dex;
    sh_int     perm_con;
    sh_int     mod_str;
    sh_int     mod_int;
    sh_int     mod_wis;
    sh_int     mod_dex;
    sh_int     mod_con;
    sh_int     quest;
    sh_int     obj_vnum;
    sh_int     condition   [3];
    sh_int     learned     [MAX_SKILL];
};



/*
* Liquids.
*/
#define LIQ_WATER        0
#define LIQ_MAX      16

struct   liq_type
{
    char *  liq_name;
    char *  liq_color;
    sh_int  liq_affect[3];
};



/*
* Extra description data for a room or object.
*/
struct   extra_descr_data
{
    EXTRA_DESCR_DATA *next;   /* Next in list                     */
    char *keyword;              /* Keyword in look/examine          */
    char *description;          /* What to see                      */
};



/*
* Prototype for an object.
*/
struct   obj_index_data
{
    OBJ_INDEX_DATA * next;
    EXTRA_DESCR_DATA *  extra_descr;
    AFFECT_DATA * affected;
    char *     name;
    char *     short_descr;
    char *     description;
    char *     chpoweron;
    char *     chpoweroff;
    char *     chpoweruse;
    char *     victpoweron;
    char *     victpoweroff;
    char *     victpoweruse;
    char *     questmaker;
    char *     questowner;
    long       vnum;
    sh_int     item_type;
    long       extra_flags;      /* changes sh_int to int */
    long       wear_flags;
    sh_int     count;
    long       weight;
    sh_int     spectype;
    sh_int     specpower;
    sh_int     condition;
    sh_int     toughness;
    sh_int     resistance;
    long       quest;
    long       points;
    long       cost;       /* Unused */
    int        value [5];
};



/*
* One object.
*/
struct   obj_data
{
    OBJ_DATA *    next;
    OBJ_DATA *    next_content;
    OBJ_DATA *    contains;
    OBJ_DATA *    in_obj;
    CHAR_DATA *      carried_by;
    CHAR_DATA *      chobj;
    EXTRA_DESCR_DATA *  extra_descr;
    AFFECT_DATA * affected;
    OBJ_INDEX_DATA * pIndexData;
    ROOM_INDEX_DATA *   in_room;
    char *     name;
    char *     short_descr;
    char *     description;
    char *     chpoweron;
    char *     chpoweroff;
    char *     chpoweruse;
    char *     victpoweron;
    char *     victpoweroff;
    char *     victpoweruse;
    char *     questmaker;
    char *     questowner;
    sh_int     item_type;
    long       extra_flags;
    long       wear_flags;
    sh_int     wear_loc;
    long       weight;
    sh_int     spectype;
    sh_int     specpower;
    sh_int     condition;
    sh_int     toughness;
    sh_int     resistance;
    long       quest;
    long       points;
    long       cost;
    sh_int     level;
    sh_int     timer;
    int        value [4];
};



/*
* Exit data.
*/
struct   exit_data
{
    ROOM_INDEX_DATA *   to_room;
    long       vnum;
    sh_int     exit_info;
    long       key;
    char *     keyword;
    char *     description;
};



/*
* Room text checking data.
*/
typedef struct roomtext_data
{
    long          type;
    long          power;
    long          mob;
    char *        input;
    char *        output;
    char *        choutput;
    char *        name;
    struct roomtext_data   *next;
} ROOMTEXT_DATA;



/*
* Reset commands:
*   '*': comment
*   'M': read a mobile 
*   'O': read an object
*   'P': put object in object
*   'G': give object to mobile
*   'E': equip object to mobile
*   'D': set state of door
*   'R': randomize room exits
*   'S': stop (end of list)
*/

/*
* Area-reset definition.
*/
struct   reset_data
{
    RESET_DATA *  next;
    char    command;
    long     arg1;
    long     arg2;
    long     arg3;
};



/*
* Area definition.
*/
struct   area_data
{
    AREA_DATA *      next;
    RESET_DATA *  reset_first;
    RESET_DATA *  reset_last;
    char *     name;
    sh_int     age;
    sh_int     nplayer;
};



/*
* Room type.
*/
struct   room_index_data
{
    ROOM_INDEX_DATA *   next;
    CHAR_DATA *      people;
    OBJ_DATA *    contents;
    EXTRA_DESCR_DATA *  extra_descr;
    AREA_DATA *      area;
    EXIT_DATA *      exit  [6];
    ROOMTEXT_DATA *  roomtext;
    char *     name;
    char *     description;
    long       vnum;
    long       room_flags;
    sh_int     light;
    sh_int     blood;
    sh_int     sector_type;
    sh_int     bomb;
    sh_int     area_number;  /* Added by Joker room_number?? */
};



/*
* Types of attacks.
* Must be non-overlapping with spell/skill types,
* but may be arbitrary beyond that.
*/
#define TYPE_UNDEFINED               -1
#define TYPE_HIT                     1000



/*
*  Target types.
*/
#define TAR_IGNORE          0
#define TAR_CHAR_OFFENSIVE     1
#define TAR_CHAR_DEFENSIVE     2
#define TAR_CHAR_SELF          3
#define TAR_OBJ_INV         4



/*
* Skills include spells as a particular case.
*/
struct   skill_type
{
    char *  name;       /* Name of skill     */
    sh_int  skill_level[MAX_CLASS]; /* Level needed by class   */
    SPELL_FUN *   spell_fun;     /* Spell pointer (for spells) */
    sh_int  target;        /* Legal targets     */
    sh_int  minimum_position; /* Position for caster / user */
    sh_int *   pgsn;       /* Pointer to associated gsn  */
    sh_int  slot;       /* Slot for #OBJECT loading   */
    sh_int  min_mana;      /* Minimum mana used    */
    sh_int  beats;         /* Waiting time after use  */
    char *  noun_damage;      /* Damage message    */
    char *  msg_off;    /* Wear off message     */
};



/*
* These are skill_lookup return values for common skills and spells.
*/
extern   sh_int   gsn_backstab;
extern   sh_int   gsn_hide;
extern   sh_int   gsn_peek;
extern   sh_int   gsn_pick_lock;
extern   sh_int   gsn_sneak;
extern   sh_int   gsn_steal;

extern   sh_int   gsn_fastdraw;
extern   sh_int   gsn_berserk;
extern   sh_int   gsn_punch;
extern   sh_int   gsn_disarm;
extern   sh_int   gsn_hurl;
extern   sh_int   gsn_kick;
extern   sh_int   gsn_rescue;

extern   sh_int   gsn_blindness;
extern   sh_int   gsn_charm_person;
extern   sh_int   gsn_curse;
extern   sh_int   gsn_invis;
extern   sh_int   gsn_mass_invis;
extern   sh_int   gsn_poison;
extern   sh_int   gsn_sleep;
extern  sh_int    gsn_hunt;


/*
* Utility macros.
*/
#define UMIN(a, b)      ((a) < (b) ? (a) : (b))
#define UMAX(a, b)      ((a) > (b) ? (a) : (b))
#define URANGE(a, b, c)    ((b) < (a) ? (a) : ((b) > (c) ? (c) : (b)))
#define LOWER(c)     ((c) >= 'A' && (c) <= 'Z' ? (c)+'a'-'A' : (c))
#define UPPER(c)     ((c) >= 'a' && (c) <= 'z' ? (c)+'A'-'a' : (c))
#define IS_SET(flag, bit)  ((flag) & (bit))
#define SET_BIT(var, bit)  ((var) |= (bit))
#define REMOVE_BIT(var, bit)  ((var) &= ~(bit))
#define SWAP(a,b)	( (a)^=(b), (b)^=(a), (a)^=(b) )



/*
* Character macros.
*/
#define IS_NPC(ch)      (IS_SET((ch)->act, ACT_IS_NPC))
#define IS_JUDGE(ch)    (get_trust(ch) >= LEVEL_JUDGE)
#define IS_IMMORTAL(ch)    (get_trust(ch) > LEVEL_JUSTICAR)
#define IS_JOKER(ch)     (get_trust(ch) == LEVEL_JOKER)
#define IS_HERO(ch)     (get_trust(ch) >= LEVEL_HERO)
#define IS_AFFECTED(ch, sn)   (IS_SET((ch)->affected_by, (sn)))
#define IS_ITEMAFF(ch, sn) (IS_SET((ch)->itemaffect, (sn)))
#define IS_IMMUNE(ch, sn)  (IS_SET((ch)->immune, (sn)))
#define IS_VAMPAFF(ch, sn) (IS_SET((ch)->vampaff, (sn)))
#define IS_VAMPPASS(ch, sn)   (IS_SET((ch)->vamppass, (sn)))
#define IS_FORM(ch, sn)    (IS_SET((ch)->form, (sn)))
#define IS_POLYAFF(ch, sn) (IS_SET((ch)->polyaff, (sn)))
#define IS_EXTRA(ch, sn)   (IS_SET((ch)->extra, (sn)))
#define IS_STANCE(ch, sn)  (IS_SET((ch)->stance[0], (sn)))

#define IS_HEAD(ch, sn)    (IS_SET((ch)->loc_hp[0], (sn)))
#define IS_BODY(ch, sn)    (IS_SET((ch)->loc_hp[1], (sn)))
#define IS_ARM_L(ch, sn)   (IS_SET((ch)->loc_hp[2], (sn)))
#define IS_ARM_R(ch, sn)   (IS_SET((ch)->loc_hp[3], (sn)))
#define IS_LEG_L(ch, sn)   (IS_SET((ch)->loc_hp[4], (sn)))
#define IS_LEG_R(ch, sn)   (IS_SET((ch)->loc_hp[5], (sn)))
#define IS_BLEEDING(ch, sn)   (IS_SET((ch)->loc_hp[6], (sn)))

#define IS_GOOD(ch)     (ch->alignment >= 350)
#define IS_EVIL(ch)     (ch->alignment <= -350)
#define IS_NEUTRAL(ch)     (!IS_GOOD(ch) && !IS_EVIL(ch))

#define IS_AWAKE(ch)    (ch->position > POS_SLEEPING)
#define GET_AC(ch)      ((ch)->armor                \
    + ( IS_AWAKE(ch)           \
    ? dex_app[get_curr_dex(ch)].defensive   \
: 0 ))
#define GET_HITROLL(ch)    ((ch)->hitroll+str_app[get_curr_str(ch)].tohit)
#define GET_DAMROLL(ch)    ((ch)->damroll+str_app[get_curr_str(ch)].todam)

#define IS_OUTSIDE(ch)     (!IS_SET(                \
    (ch)->in_room->room_flags,          \
ROOM_INDOORS))

#define WAIT_STATE(ch, npulse)   ((ch)->wait = UMAX((ch)->wait, (npulse)))



/*
* Object Macros.
*/
#define CAN_WEAR(obj, part)   (IS_SET((obj)->wear_flags,  (part)))
#define IS_OBJ_STAT(obj, stat)   (IS_SET((obj)->extra_flags, (stat)))



/*
* Description macros.
*/
#define PERS(ch, looker)   ( can_see( looker, (ch) ) ?      \
				( IS_NPC(ch) ? (ch)->short_descr \
				: ( IS_AFFECTED( (ch), AFF_POLYMORPH) ?   \
				(ch)->morph : (ch)->name ) )     \
: "someone" )



/*
* Structure for a command in the command lookup table.
*/
struct   cmd_type
{
    char * const  name;
    DO_FUN *      do_fun;
    sh_int     position;
    sh_int     level;
    sh_int     log;
};



/*
* Structure for a social in the socials table.
*/
struct   social_type
{
    char * const  name;
    char * const  char_no_arg;
    char * const  others_no_arg;
    char * const  char_found;
    char * const  others_found;
    char * const  vict_found;
    char * const  char_auto;
    char * const  others_auto;
};



/*
* Global constants.
*/
extern   const struct   str_app_type   str_app     [26];
extern   const struct   int_app_type   int_app     [26];
extern   const struct   wis_app_type   wis_app     [26];
extern   const struct   dex_app_type   dex_app     [26];
extern   const struct   con_app_type   con_app     [26];

extern   const struct   class_type  class_table [MAX_CLASS];
extern   const struct   cmd_type cmd_table   [];
extern   const struct   liq_type liq_table   [LIQ_MAX];
extern   const struct   skill_type  skill_table [MAX_SKILL];
extern   const struct   social_type social_table   [];
extern   char *   const       title_table [MAX_CLASS]
[MAX_LEVEL+1]
[2];
extern  char *  const  dir_name [];


/*
* Global variables.
*/
extern      HELP_DATA     *   help_first;
extern      SHOP_DATA     *   shop_first;

extern      BAN_DATA   *   ban_list;
extern      CHAR_DATA     *   char_list;
extern      DESCRIPTOR_DATA   *  descriptor_list;
extern      NOTE_DATA     *   note_list;
extern      OBJ_DATA   *   object_list;

extern      AFFECT_DATA   *   affect_free;
extern      BAN_DATA   *   ban_free;
extern      CHAR_DATA     *   char_free;
extern      DESCRIPTOR_DATA     *   descriptor_free;
extern      EXTRA_DESCR_DATA  *  extra_descr_free;
extern      ROOMTEXT_DATA     *  roomtext_free;
extern      NOTE_DATA     *   note_free;
extern      OBJ_DATA   *   obj_free;
extern      PC_DATA       *   pcdata_free;

extern      char        bug_buf     [];
extern      time_t         current_time;
extern      bool        fLogAll;
extern      FILE *         fpReserve;
extern      KILL_DATA      kill_table  [];
extern      char        log_buf     [];
extern      TIME_INFO_DATA    time_info;
extern      WEATHER_DATA      weather_info;
extern          CLAN_INFO               clan_infotable[MAX_CLAN];
extern	    LEAGUE_INFO	    league_infotable[MAX_PLAYERS];

/*
* Command functions.
* Defined in act_*.c (mostly).
*/
DECLARE_DO_FUN(   do_activate );
DECLARE_DO_FUN(   do_alignment   );
DECLARE_DO_FUN(   do_allow );
DECLARE_DO_FUN(   do_ansi     );
DECLARE_DO_FUN(   do_answer   );
DECLARE_DO_FUN(   do_areas );
DECLARE_DO_FUN(   do_at    );
DECLARE_DO_FUN(   do_auction  );
DECLARE_DO_FUN(   do_autoexit );
DECLARE_DO_FUN(   do_autoloot );
DECLARE_DO_FUN(   do_autosac  );
DECLARE_DO_FUN(   do_backstab );
DECLARE_DO_FUN(   do_bamfin   );
DECLARE_DO_FUN(   do_bamfout  );
DECLARE_DO_FUN(   do_ban      );
DECLARE_DO_FUN(   do_beastlike   );
DECLARE_DO_FUN(   do_berserk  );
DECLARE_DO_FUN(   do_bind     );
DECLARE_DO_FUN(   do_bite     );
DECLARE_DO_FUN(   do_blank );
DECLARE_DO_FUN(   do_fightconfig );
DECLARE_DO_FUN(   do_fight2config );
DECLARE_DO_FUN(   do_bid      );
DECLARE_DO_FUN(   do_blindfold   );
DECLARE_DO_FUN(   do_brandish );
DECLARE_DO_FUN(   do_brief );
DECLARE_DO_FUN(   do_brutalk );
DECLARE_DO_FUN(   do_bug      );
DECLARE_DO_FUN(   do_buy      );
DECLARE_DO_FUN(   do_call     );
DECLARE_DO_FUN(   do_captalk );
DECLARE_DO_FUN(   do_cast     );
DECLARE_DO_FUN(   do_cemote   );
DECLARE_DO_FUN(   do_change   );
DECLARE_DO_FUN(   do_changelight );
DECLARE_DO_FUN(   do_channels );
DECLARE_DO_FUN(   do_chat     );
DECLARE_DO_FUN(   do_mchat    );
DECLARE_DO_FUN(   do_claim );
DECLARE_DO_FUN(   do_clandisc );
DECLARE_DO_FUN(   do_claninfo );
DECLARE_DO_FUN(   do_clanname     );
DECLARE_DO_FUN(   do_claws );
DECLARE_DO_FUN(   do_clearvam );
DECLARE_DO_FUN(   do_clearvamp   );
DECLARE_DO_FUN(   do_close );
DECLARE_DO_FUN(   do_command  );
DECLARE_DO_FUN(   do_commands );
DECLARE_DO_FUN(   do_compare  );
DECLARE_DO_FUN(   do_complete );
DECLARE_DO_FUN(   do_config   );
DECLARE_DO_FUN(   do_connections   );
DECLARE_DO_FUN(   do_consider );
DECLARE_DO_FUN(   do_crack );
DECLARE_DO_FUN(   do_create   );
DECLARE_DO_FUN(   do_credits  );
DECLARE_DO_FUN(   do_darkheart   );
DECLARE_DO_FUN(   do_donate      );
DECLARE_DO_FUN(   do_decapitate  );
DECLARE_DO_FUN(   do_deny     );
DECLARE_DO_FUN(   do_deposit  );
DECLARE_DO_FUN(   do_clanbalance );
DECLARE_DO_FUN(   do_clandeposit );
DECLARE_DO_FUN(   do_clanwithdraw );
DECLARE_DO_FUN(   do_description );
DECLARE_DO_FUN(   do_diagnose );
DECLARE_DO_FUN(   do_dismount );
DECLARE_DO_FUN(   do_disarm   );
DECLARE_DO_FUN(   do_disconnect  );
DECLARE_DO_FUN(   do_punt  );
DECLARE_DO_FUN(   do_down     );
DECLARE_DO_FUN(   do_draw     );
DECLARE_DO_FUN(   do_drink );
DECLARE_DO_FUN(   do_drop     );
DECLARE_DO_FUN(   do_east     );
DECLARE_DO_FUN(   do_eat      );
DECLARE_DO_FUN(   do_echo     );
DECLARE_DO_FUN(   do_empty );
DECLARE_DO_FUN(   do_escape   );
DECLARE_DO_FUN(   do_info     );
DECLARE_DO_FUN(   do_ordain   );
DECLARE_DO_FUN(   do_emote );
DECLARE_DO_FUN(   do_enter );
DECLARE_DO_FUN(   do_equipment   );
DECLARE_DO_FUN(   do_evileye  );
DECLARE_DO_FUN(   do_examine  );
DECLARE_DO_FUN(   do_exits );
DECLARE_DO_FUN(   do_email );
DECLARE_DO_FUN(   do_fangs );
DECLARE_DO_FUN(   do_finger);
DECLARE_DO_FUN(   do_favour   );
DECLARE_DO_FUN(   do_feed     );
DECLARE_DO_FUN(   do_fightstyle  );
DECLARE_DO_FUN(   do_fill     );
DECLARE_DO_FUN(   do_flee     );
DECLARE_DO_FUN(   do_follow   );
DECLARE_DO_FUN(   do_force );
DECLARE_DO_FUN(   do_forceauto   );
DECLARE_DO_FUN(   do_autosave );
DECLARE_DO_FUN(   do_freeze   );
DECLARE_DO_FUN(   do_gag      );
DECLARE_DO_FUN(   do_gangtalk );
DECLARE_DO_FUN(   do_get      );
DECLARE_DO_FUN(   do_gift     );
DECLARE_DO_FUN(   do_give     );
DECLARE_DO_FUN(   do_godless  );
DECLARE_DO_FUN(   do_godwho   );
DECLARE_DO_FUN(   do_goto     );
DECLARE_DO_FUN(   do_group );
DECLARE_DO_FUN(   do_gtell );
DECLARE_DO_FUN(   do_help     );
DECLARE_DO_FUN(   do_hide     );
DECLARE_DO_FUN(   do_home     );
DECLARE_DO_FUN(   do_holylight   );
DECLARE_DO_FUN(   do_humanity );
DECLARE_DO_FUN(   do_hunt     ); 
DECLARE_DO_FUN(   do_trap     );
DECLARE_DO_FUN(   do_addlag   );
DECLARE_DO_FUN(   do_sinbin   );
DECLARE_DO_FUN(   do_outcast  );
DECLARE_DO_FUN(   do_hurl     );
DECLARE_DO_FUN(   do_idea     );
DECLARE_DO_FUN(   do_immune   );
DECLARE_DO_FUN(   do_immtalk  );
DECLARE_DO_FUN(   do_introduce   );
DECLARE_DO_FUN(   do_inventory   );
DECLARE_DO_FUN(   do_invis );
DECLARE_DO_FUN(   do_kick     );
DECLARE_DO_FUN(   do_kill     );
DECLARE_DO_FUN(   do_killperson  );
DECLARE_DO_FUN(   do_list     );
DECLARE_DO_FUN(   do_locate   );
DECLARE_DO_FUN(   do_lock     );
DECLARE_DO_FUN(   do_log      );
DECLARE_DO_FUN(   do_look     );
DECLARE_DO_FUN(   do_malktalk );
DECLARE_DO_FUN(   do_mask     );
DECLARE_DO_FUN(   do_mclear   );
DECLARE_DO_FUN(   do_member   );
DECLARE_DO_FUN(   do_memory   );
DECLARE_DO_FUN(   do_mfind );
DECLARE_DO_FUN(   do_mload );
DECLARE_DO_FUN(   do_mount );
DECLARE_DO_FUN(   do_morph );
DECLARE_DO_FUN(   do_mortal   );
DECLARE_DO_FUN(   do_mortalvamp  );
DECLARE_DO_FUN(   do_mset     );
DECLARE_DO_FUN(   do_mstat );
DECLARE_DO_FUN(   do_mwhere   );
DECLARE_DO_FUN(   do_music );
DECLARE_DO_FUN(   do_nightsight  );
DECLARE_DO_FUN(   do_noemote  );
DECLARE_DO_FUN(   do_north );
DECLARE_DO_FUN(   do_nostalk );
DECLARE_DO_FUN(   do_note     );
DECLARE_DO_FUN(   do_notell   );
DECLARE_DO_FUN(   do_oclone   );
DECLARE_DO_FUN(   do_ofind );
DECLARE_DO_FUN(   do_oload );
DECLARE_DO_FUN(   do_omember );
DECLARE_DO_FUN(   do_open     );
DECLARE_DO_FUN(   do_order );
DECLARE_DO_FUN(   do_orgy  );
DECLARE_DO_FUN(   do_pers  );
DECLARE_DO_FUN(   do_oreturn  );
DECLARE_DO_FUN(   do_oset     );
DECLARE_DO_FUN(   do_ostat );
DECLARE_DO_FUN(   do_oswitch  );
DECLARE_DO_FUN(   do_otransfer   );
DECLARE_DO_FUN(   do_password );
DECLARE_DO_FUN(   do_peace );
DECLARE_DO_FUN(   do_pick     );
DECLARE_DO_FUN(   do_pload );
DECLARE_DO_FUN(   do_personal );
DECLARE_DO_FUN(   do_poison   );
DECLARE_DO_FUN(   do_pose     );
DECLARE_DO_FUN(   do_practice );
DECLARE_DO_FUN( do_prac1        );
DECLARE_DO_FUN( do_prac2        );
DECLARE_DO_FUN(   do_press );
DECLARE_DO_FUN(   do_preturn  );
DECLARE_DO_FUN(   do_pull     );
DECLARE_DO_FUN(   do_punch );
DECLARE_DO_FUN(   do_purge );
DECLARE_DO_FUN(   do_put      );
DECLARE_DO_FUN(   do_qbuy  );
DECLARE_DO_FUN(   do_qlist );
DECLARE_DO_FUN(   do_qmake );
DECLARE_DO_FUN(   do_quaff );
DECLARE_DO_FUN(   do_qset     );
DECLARE_DO_FUN(   do_qstat );
DECLARE_DO_FUN(   do_qtrust   );
DECLARE_DO_FUN(   do_quest );
DECLARE_DO_FUN(   do_question );
DECLARE_DO_FUN(   do_qui      );
DECLARE_DO_FUN(   do_updateleague);
DECLARE_DO_FUN(   do_quit     );
DECLARE_DO_FUN(   do_rage     );
DECLARE_DO_FUN(   do_readaura );
DECLARE_DO_FUN(   do_reboo );
DECLARE_DO_FUN(   do_reboot   );
DECLARE_DO_FUN(   do_recall   );
DECLARE_DO_FUN(   do_recharge );
DECLARE_DO_FUN(   do_recho );
DECLARE_DO_FUN(   do_recite   );
DECLARE_DO_FUN(   do_refresh );
DECLARE_DO_FUN(   do_regenerate  );
DECLARE_DO_FUN(   do_release  );
DECLARE_DO_FUN(   do_relevel  );
DECLARE_DO_FUN(   do_muddie   );
DECLARE_DO_FUN(   do_avatar   );
DECLARE_DO_FUN(   do_reload   );
DECLARE_DO_FUN(   do_remove   );
DECLARE_DO_FUN(   do_rent     );
DECLARE_DO_FUN(   do_reply );
DECLARE_DO_FUN(   do_report   );
DECLARE_DO_FUN(   do_rescue   );
DECLARE_DO_FUN(   do_rest     );
DECLARE_DO_FUN(   do_restore  );
DECLARE_DO_FUN(   do_return   );
DECLARE_DO_FUN(   do_review   );
DECLARE_DO_FUN(   do_rset     );
DECLARE_DO_FUN(   do_rstat );
DECLARE_DO_FUN(   do_sabbat );
DECLARE_DO_FUN(   do_sacrifice   );
DECLARE_DO_FUN(   do_safe     );
DECLARE_DO_FUN(   do_save     );
DECLARE_DO_FUN(   do_say      );
DECLARE_DO_FUN(   do_scan     );
DECLARE_DO_FUN(   do_score );
DECLARE_DO_FUN(   do_scry     );
DECLARE_DO_FUN(   do_sell     );
DECLARE_DO_FUN(   do_serpent  );
DECLARE_DO_FUN(   do_shadowplane );
DECLARE_DO_FUN(   do_shadowsight );
DECLARE_DO_FUN(   do_sheath   );
DECLARE_DO_FUN(   do_shield   );
DECLARE_DO_FUN(   do_affect   );
DECLARE_DO_FUN(   do_shoot );
DECLARE_DO_FUN(   do_shout );
DECLARE_DO_FUN(   do_shutdow  );
DECLARE_DO_FUN(   do_shutdown );
DECLARE_DO_FUN(   do_side     );
DECLARE_DO_FUN(   do_silence  );
DECLARE_DO_FUN(   do_skill );
DECLARE_DO_FUN(   do_sla      );
DECLARE_DO_FUN(   do_slay     );
DECLARE_DO_FUN(   do_sleep );
DECLARE_DO_FUN(   do_slookup  );
DECLARE_DO_FUN(   do_speak );
DECLARE_DO_FUN(   do_spell );
DECLARE_DO_FUN(   do_stake );
DECLARE_DO_FUN(   do_stance   );
DECLARE_DO_FUN(   do_smother  );
DECLARE_DO_FUN(   do_sneak );
DECLARE_DO_FUN(   do_snoop );
DECLARE_DO_FUN(   do_socials  );
DECLARE_DO_FUN(   do_south );
DECLARE_DO_FUN(   do_split );
DECLARE_DO_FUN(   do_spy      );
DECLARE_DO_FUN(   do_spydirection   );
DECLARE_DO_FUN(   do_sset     );
DECLARE_DO_FUN(   do_stancetable  );
DECLARE_DO_FUN(   do_stancetable2 );
DECLARE_DO_FUN(   do_stand );
DECLARE_DO_FUN(   do_steal );
DECLARE_DO_FUN(   do_summon   );
DECLARE_DO_FUN(   do_switch   );
DECLARE_DO_FUN(   do_tell     );
DECLARE_DO_FUN(   do_throw );
DECLARE_DO_FUN(   do_struggle );
DECLARE_DO_FUN(   do_tie      );
DECLARE_DO_FUN(   do_time     );
DECLARE_DO_FUN(   do_title );
DECLARE_DO_FUN(   do_token );
DECLARE_DO_FUN(   do_tortalk );
DECLARE_DO_FUN(   do_track );
DECLARE_DO_FUN(   do_tradition   );
DECLARE_DO_FUN(   do_transport   );
DECLARE_DO_FUN(   do_train );
DECLARE_DO_FUN(   do_transfer );
DECLARE_DO_FUN(   do_tremtalk );
DECLARE_DO_FUN(   do_truesight   );
DECLARE_DO_FUN(   do_trust );
DECLARE_DO_FUN(   do_twist );
DECLARE_DO_FUN(   do_typo     );
DECLARE_DO_FUN(   do_unload   );
DECLARE_DO_FUN(   do_unlock   );
DECLARE_DO_FUN(   do_untie );
DECLARE_DO_FUN(   do_up    );
DECLARE_DO_FUN(   do_upkeep   );
DECLARE_DO_FUN(   do_users );
DECLARE_DO_FUN(   do_value );
DECLARE_DO_FUN(   do_vampire  );
DECLARE_DO_FUN(   do_vamptalk );
DECLARE_DO_FUN(   do_vclan );
DECLARE_DO_FUN(   do_ventalk );
DECLARE_DO_FUN(   do_visible  );
DECLARE_DO_FUN(   do_voodoo   );
DECLARE_DO_FUN(   do_justitalk );
DECLARE_DO_FUN(   do_vouch  );
DECLARE_DO_FUN(   do_wake     );
DECLARE_DO_FUN(   do_watcher  );
DECLARE_DO_FUN(   do_watching );
DECLARE_DO_FUN(   do_weapontable  );
DECLARE_DO_FUN(   do_wear     );
DECLARE_DO_FUN(   do_wearaffect  );
DECLARE_DO_FUN(   do_weather  );
DECLARE_DO_FUN(   do_west     );
DECLARE_DO_FUN(   do_where );
DECLARE_DO_FUN(   do_who      );
DECLARE_DO_FUN(   do_wimpy );
DECLARE_DO_FUN(   do_withdraw );
DECLARE_DO_FUN(   do_wizhelp  );
DECLARE_DO_FUN(   do_wizlist  );
DECLARE_DO_FUN(   do_wizlock  );
DECLARE_DO_FUN(   do_yell     );
DECLARE_DO_FUN(   do_zap      );



/*
* Spell functions.
* Defined in magic.c.
*/
DECLARE_SPELL_FUN(   spell_null     );
DECLARE_SPELL_FUN(   spell_acid_blast  );
DECLARE_SPELL_FUN(   spell_armor    );
DECLARE_SPELL_FUN(   spell_bless    );
DECLARE_SPELL_FUN(   spell_blindness      );
DECLARE_SPELL_FUN(   spell_burning_hands  );
DECLARE_SPELL_FUN(   spell_call_lightning );
DECLARE_SPELL_FUN(   spell_cause_critical );
DECLARE_SPELL_FUN(   spell_cause_light );
DECLARE_SPELL_FUN(   spell_cause_serious  );
DECLARE_SPELL_FUN(   spell_change_sex  );
DECLARE_SPELL_FUN(   spell_charm_person   );
DECLARE_SPELL_FUN(   spell_chill_touch );
DECLARE_SPELL_FUN(   spell_colour_spray   );
DECLARE_SPELL_FUN(   spell_continual_light   );
DECLARE_SPELL_FUN(   spell_control_weather   );
DECLARE_SPELL_FUN(   spell_create_food );
DECLARE_SPELL_FUN(   spell_create_spring  );
DECLARE_SPELL_FUN(   spell_create_water   );
DECLARE_SPELL_FUN(   spell_cure_blindness );
DECLARE_SPELL_FUN(   spell_cure_critical  );
DECLARE_SPELL_FUN(   spell_cure_light  );
DECLARE_SPELL_FUN(   spell_cure_poison );
DECLARE_SPELL_FUN(   spell_cure_serious   );
DECLARE_SPELL_FUN(   spell_curse    );
DECLARE_SPELL_FUN(   spell_detect_evil );
DECLARE_SPELL_FUN(   spell_detect_hidden  );
DECLARE_SPELL_FUN(   spell_detect_invis   );
DECLARE_SPELL_FUN(   spell_detect_magic   );
DECLARE_SPELL_FUN(   spell_detect_poison  );
DECLARE_SPELL_FUN(   spell_dispel_evil );
DECLARE_SPELL_FUN(   spell_dispel_magic   );
DECLARE_SPELL_FUN(   spell_earthquake  );
DECLARE_SPELL_FUN(   spell_enchant_weapon );
DECLARE_SPELL_FUN(   spell_energy_drain   );
DECLARE_SPELL_FUN(   spell_faerie_fire );
DECLARE_SPELL_FUN(   spell_faerie_fog  );
DECLARE_SPELL_FUN(   spell_fireball    );
DECLARE_SPELL_FUN(   spell_flamestrike );
DECLARE_SPELL_FUN(   spell_fly      );
DECLARE_SPELL_FUN(   spell_gate     );
DECLARE_SPELL_FUN(   spell_general_purpose   );
DECLARE_SPELL_FUN(   spell_giant_strength );
DECLARE_SPELL_FUN(   spell_harm     );
DECLARE_SPELL_FUN(   spell_heal     );
DECLARE_SPELL_FUN(   spell_high_explosive );
DECLARE_SPELL_FUN(   spell_identify    );
DECLARE_SPELL_FUN(   spell_infravision );
DECLARE_SPELL_FUN(   spell_invis    );
DECLARE_SPELL_FUN(   spell_know_alignment );
DECLARE_SPELL_FUN(   spell_lightning_bolt );
DECLARE_SPELL_FUN(   spell_locate_object  );
DECLARE_SPELL_FUN(   spell_magic_missile  );
DECLARE_SPELL_FUN(   spell_mass_invis  );
DECLARE_SPELL_FUN(   spell_pass_door      );
DECLARE_SPELL_FUN(   spell_poison      );
DECLARE_SPELL_FUN(   spell_protection  );
DECLARE_SPELL_FUN(   spell_refresh     );
DECLARE_SPELL_FUN(   spell_remove_curse   );
DECLARE_SPELL_FUN(   spell_sanctuary      );
DECLARE_SPELL_FUN(   spell_shocking_grasp );
DECLARE_SPELL_FUN(   spell_shield      );
DECLARE_SPELL_FUN(   spell_sleep    );
DECLARE_SPELL_FUN(   spell_stone_skin  );
DECLARE_SPELL_FUN(   spell_summon      );
DECLARE_SPELL_FUN(   spell_teleport    );
DECLARE_SPELL_FUN(   spell_ventriloquate  );
DECLARE_SPELL_FUN(   spell_weaken      );
DECLARE_SPELL_FUN(   spell_word_of_recall );
DECLARE_SPELL_FUN(   spell_acid_breath );
DECLARE_SPELL_FUN(   spell_fire_breath );
DECLARE_SPELL_FUN(   spell_frost_breath   );
DECLARE_SPELL_FUN(   spell_gas_breath  );
DECLARE_SPELL_FUN(   spell_lightning_breath  );
DECLARE_SPELL_FUN(   spell_guardian    );
DECLARE_SPELL_FUN(   spell_soulblade      );
DECLARE_SPELL_FUN(   spell_mana     );
DECLARE_SPELL_FUN(   spell_frenzy      );
DECLARE_SPELL_FUN(   spell_darkblessing   );
DECLARE_SPELL_FUN(   spell_portal      );
DECLARE_SPELL_FUN(   spell_energyflux  );
DECLARE_SPELL_FUN(   spell_voodoo      );
DECLARE_SPELL_FUN(   spell_transport      );
DECLARE_SPELL_FUN(   spell_regenerate  );
DECLARE_SPELL_FUN(   spell_clot     );
DECLARE_SPELL_FUN(   spell_mend     );
DECLARE_SPELL_FUN(   spell_quest    );
DECLARE_SPELL_FUN(   spell_minor_creation );
DECLARE_SPELL_FUN(   spell_brew     );
DECLARE_SPELL_FUN(   spell_scribe      );
DECLARE_SPELL_FUN(   spell_carve    );
DECLARE_SPELL_FUN(   spell_engrave     );
DECLARE_SPELL_FUN(   spell_bake     );
DECLARE_SPELL_FUN(   spell_mount    );
DECLARE_SPELL_FUN(   spell_scan     );
DECLARE_SPELL_FUN(   spell_repair      );
DECLARE_SPELL_FUN(   spell_spellproof  );
DECLARE_SPELL_FUN(      spell_clone             );
DECLARE_SPELL_FUN(      spell_reveal      );

/*
* OS-dependent declarations.
* These are all very standard library functions,
*   but some systems have incomplete or non-ansi header files.
*/
#if   defined(_AIX)
char *   crypt    args( ( const char *key, const char *salt ) );
#endif

#if   defined(apollo)
int   atoi     args( ( const char *string ) );
void *   calloc      args( ( unsigned nelem, size_t size ) );
char *   crypt    args( ( const char *key, const char *salt ) );
#endif

#if   defined(hpux)
char *   crypt    args( ( const char *key, const char *salt ) );
#endif

#if   defined(interactive)
#endif

#if   defined(linux)
#include <crypt.h>
/*char *   crypt    args( ( const char *key, const char *salt ) );*/
#endif

#if   defined(macintosh)
#define NOCRYPT
#if   defined(unix)
#undef   unix
#endif
#endif

#if   defined(MIPS_OS)
char *   crypt    args( ( const char *key, const char *salt ) );
#endif

#if   defined(MSDOS)
#define NOCRYPT
#if   defined(unix)
#undef   unix
#endif
#endif

#if   defined(NeXT)
char *   crypt    args( ( const char *key, const char *salt ) );
#endif

#if   defined(sequent)
char *   crypt    args( ( const char *key, const char *salt ) );
int   fclose      args( ( FILE *stream ) );
int   fprintf     args( ( FILE *stream, const char *format, ... ) );
int   fread    args( ( void *ptr, int size, int n, FILE *stream ) );
int   fseek    args( ( FILE *stream, long offset, int ptrname ) );
void  perror      args( ( const char *s ) );
int   ungetc      args( ( int c, FILE *stream ) );
#endif

#if   defined(sun)
char *   crypt    args( ( const char *key, const char *salt ) );
int   fclose      args( ( FILE *stream ) );
int   fprintf     args( ( FILE *stream, const char *format, ... ) );
#if   defined(SYSV)
size_t   fread    args( ( void *ptr, size_t size, size_t n, 
				   FILE *stream ) );
#else
int   fread    args( ( void *ptr, int size, int n, FILE *stream ) );
#endif
int   fseek    args( ( FILE *stream, long offset, int ptrname ) );
void  perror      args( ( const char *s ) );
int   ungetc      args( ( int c, FILE *stream ) );
#endif

#if   defined(ultrix)
char *   crypt    args( ( const char *key, const char *salt ) );
#endif



/*
* The crypt(3) function is not available on some operating systems.
* In particular, the U.S. Government prohibits its export from the
*   United States to foreign countries.
* Turn on NOCRYPT to keep passwords in plain text.
*/
#if   defined(NOCRYPT)
#define crypt(s1, s2)   (s1)
#endif



/*
* Data files used by the server.
*
* AREA_LIST contains a list of areas to boot.
* All files are read in completely at bootup.
* Most output files (bug, idea, typo, shutdown) are append-only.
*
* The NULL_FILE is held open so that we have a stream handle in reserve,
*   so players can go ahead and telnet to all the other descriptors.
* Then we close it whenever we need to open a file (e.g. a save file).
*/
#if defined(macintosh)
#define PLAYER_DIR   ""    /* Player files         */
#define NULL_FILE "proto.are" /* To reserve one stream   */
#endif

#if defined(MSDOS)
#define PLAYER_DIR   ""    /* Player files                 */
#define NULL_FILE "nul"    /* To reserve one stream   */
#endif

#if defined(unix)
#define PLAYER_DIR   "../player/"   /* Player files         */
#define BACKUP_DIR   "../bkup/" 
#define DELETE_DIR   "../del/"
#define NULL_FILE "/dev/null" /* To reserve one stream   */
#endif

#define AREA_LIST "area.lst"  /* List of areas     */

#define BUG_FILE  "bugs.txt"      /* For 'bug' and bug( )      */
#define IDEA_FILE "ideas.txt" /* For 'idea'        */
#define TYPO_FILE "typos.txt"     /* For 'typo'       */
#define NOTE_FILE "notes.txt" /* For 'notes'       */
#define SITEBAN_FILE "siteban.txt"  /* For sitebans */
#define SHUTDOWN_FILE   "shutdown.txt" /* For 'shutdown'    */
#define CLAN_FILE       "clan.txt"      /* For storing clan kills       */
#define PLIST_FILE      "plist.txt"    /* stores a list of players */
#define LEAGUE_FILE        "league.txt"  /* a list of banned sites. */
/*
* Our function prototypes.
* One big lump ... this is every function in Merc.
*/
#define CD  CHAR_DATA
#define MID MOB_INDEX_DATA
#define OD  OBJ_DATA
#define OID OBJ_INDEX_DATA
#define RID ROOM_INDEX_DATA
#define SF  SPEC_FUN

/* act_comm.c */
void  add_follower   args( ( CHAR_DATA *ch, CHAR_DATA *master ) );
void  stop_follower  args( ( CHAR_DATA *ch ) );
void  die_follower   args( ( CHAR_DATA *ch ) );
bool  is_same_group  args( ( CHAR_DATA *ach, CHAR_DATA *bch ) );
void  room_text   args( ( CHAR_DATA *ch, char *argument ) );
char    *strlower       args( ( char * ip ) );
void  excessive_cpu  args( ( int blx ) );

/* act_info.c */
void  set_title   args( ( CHAR_DATA *ch, char *title ) );
void  show_list_to_char args( ( OBJ_DATA *list, CHAR_DATA *ch,
					    bool fShort, bool fShowNothing ) );

void  show_drop_to_char args( ( OBJ_DATA *list, CHAR_DATA *ch,
					    bool fShort, bool fShowNothing ) );

/* act_move.c */
void  move_char   args( ( CHAR_DATA *ch, int door ) );
void  open_lift   args( ( CHAR_DATA *ch ) );
void  close_lift  args( ( CHAR_DATA *ch ) );
void  move_lift   args( ( CHAR_DATA *ch, int to_room ) );
void  move_door   args( ( CHAR_DATA *ch ) );
void  thru_door   args( ( CHAR_DATA *ch, int doorexit ) );
void  open_door   args( ( CHAR_DATA *ch, bool be_open ) );
bool  is_open     args( ( CHAR_DATA *ch ) );
bool  same_floor  args( ( CHAR_DATA *ch, int cmp_room ) );

/* act_obj.c */
bool  is_ok_to_wear  args( ( CHAR_DATA *ch, char *argument ) );
void  quest_object   args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool  remove_obj  args( ( CHAR_DATA *ch, int iWear, bool fReplace ) );
void  wear_obj args( ( CHAR_DATA *ch, OBJ_DATA *obj, bool fReplace ) );
bool  does_ch_have_a_container args( ( CHAR_DATA *ch ) );

/* act_wiz.c */
void  bind_char   args( ( CHAR_DATA *ch ) );

/* comm.c */
void  close_socket   args( ( DESCRIPTOR_DATA *dclose ) );
void  close_socket2  args( ( DESCRIPTOR_DATA *dclose ) );
void  write_to_buffer   args( ( DESCRIPTOR_DATA *d, const char *txt,
					    int length, int anti_trigger ) );
void  send_to_char   args( ( const char *txt, CHAR_DATA *ch ) );
void  send_to_char_formatted   args( ( const char *txt, CHAR_DATA *ch ) );
void  act      args( ( const char *format, CHAR_DATA *ch,
				const void *arg1, const void *arg2, int type ) );
void  kavitem     args( ( const char *format, CHAR_DATA *ch,
				   const void *arg1, const void *arg2, int type ) );
bool check_parse_name args( ( char *name) );

/* db.c */
void  boot_db     args( ( void ) );
void  area_update args( ( void ) );
CD *  create_mobile  args( ( MOB_INDEX_DATA *pMobIndex ) );
OD *  create_object  args( ( OBJ_INDEX_DATA *pObjIndex, int level ) );
void  clear_char  args( ( CHAR_DATA *ch ) );
void  free_char   args( ( CHAR_DATA *ch ) );
char *   get_extra_descr   args( ( const char *name, EXTRA_DESCR_DATA *ed ) );
char *   get_roomtext   args( ( const char *name, ROOMTEXT_DATA    *rt ) );
MID * get_mob_index  args( ( int vnum ) );
OID * get_obj_index  args( ( int vnum ) );
RID * get_room_index args( ( int vnum ) );
char  fread_letter   args( ( FILE *fp ) );
int   fread_number   args( ( FILE *fp, int ROE ) );
char *   fread_string   args( ( FILE *fp ) );
void  fread_to_eol   args( ( FILE *fp ) );
char *   fread_word  args( ( FILE *fp ) );
char *   fread_jword args( ( FILE *fp ) );
void *   alloc_mem   args( ( int sMem ) );
void *   alloc_perm  args( ( int sMem ) );
void  free_mem args( ( void *pMem, int sMem ) );
char *   str_dup     args( ( const char *str ) );
void  free_string args( ( char *pstr ) );
int   number_fuzzy   args( ( int number ) );
int   number_range   args( ( int from, int to ) );
int   number_percent args( ( void ) );
int   number_door args( ( void ) );
int   number_bits args( ( int width ) );
int   number_mm   args( ( void ) );
int   dice     args( ( int number, int size ) );
int   interpolate args( ( int level, int value_00, int value_32 ) );
void  smash_tilde args( ( char *str ) );
bool  str_cmp     args( ( const char *astr, const char *bstr ) );
bool  str_prefix  args( ( const char *astr, const char *bstr ) );
bool  str_infix   args( ( const char *astr, const char *bstr ) );
bool  str_suffix  args( ( const char *astr, const char *bstr ) );
char *   capitalize  args( ( const char *str ) );
void  append_file args( ( CHAR_DATA *ch, char *file, char *str ) );
void  bug      args( ( const char *str, int param ) );
void  log_string  args( ( const char *str ) );
void  tail_chain  args( ( void ) );

/* fight.c */
void  violence_update   args( ( void ) );
void  multi_hit   args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dt ) );
void  damage      args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam, int dt ) );
void  update_pos  args( ( CHAR_DATA *victim ) );
void  stop_fighting  args( ( CHAR_DATA *ch, bool fBoth ) );
bool  no_attack   args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );

/* handler.c */
int   get_trust   args( ( CHAR_DATA *ch ) );
int   get_age     args( ( CHAR_DATA *ch ) );
int   get_curr_str   args( ( CHAR_DATA *ch ) );
int   get_curr_int   args( ( CHAR_DATA *ch ) );
int   get_curr_wis   args( ( CHAR_DATA *ch ) );
int   get_curr_dex   args( ( CHAR_DATA *ch ) );
int   get_curr_con   args( ( CHAR_DATA *ch ) );
int   can_carry_n args( ( CHAR_DATA *ch ) );
int   can_carry_w args( ( CHAR_DATA *ch ) );
bool  is_name     args( ( const char *str, char *namelist ) );
void  affect_to_char args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void  affect_remove  args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void  affect_strip   args( ( CHAR_DATA *ch, int sn ) );
bool  is_affected args( ( CHAR_DATA *ch, int sn ) );
void  affect_join args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void  char_from_room args( ( CHAR_DATA *ch ) );
void  char_to_room   args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex ) );
void  obj_to_char args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
void  obj_from_char  args( ( OBJ_DATA *obj ) );
int   apply_ac args( ( OBJ_DATA *obj, int iWear ) );
OD *  get_eq_char args( ( CHAR_DATA *ch, int iWear ) );
void  equip_char  args( ( CHAR_DATA *ch, OBJ_DATA *obj, int iWear ) );
void  unequip_char   args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
int   count_obj_list args( ( OBJ_INDEX_DATA *obj, OBJ_DATA *list ) );
void  obj_from_room  args( ( OBJ_DATA *obj ) );
void  obj_to_room args( ( OBJ_DATA *obj, ROOM_INDEX_DATA *pRoomIndex ) );
void  obj_to_obj  args( ( OBJ_DATA *obj, OBJ_DATA *obj_to ) );
void  obj_from_obj   args( ( OBJ_DATA *obj ) );
void  extract_obj args( ( OBJ_DATA *obj ) );
void  extract_char   args( ( CHAR_DATA *ch, bool fPull ) );
CD *  get_char_room  args( ( CHAR_DATA *ch, char *argument ) );
CD *  get_char_world args( ( CHAR_DATA *ch, char *argument ) );
CD *    get_char_area   args( ( CHAR_DATA *ch, char *argument ) );
OD *  get_obj_type   args( ( OBJ_INDEX_DATA *pObjIndexData ) );
OD *  get_obj_list   args( ( CHAR_DATA *ch, char *argument,
					 OBJ_DATA *list ) );
OD *  get_obj_in_obj args( ( CHAR_DATA *ch, char *argument ) );
OD *  get_obj_carry  args( ( CHAR_DATA *ch, char *argument ) );
OD *  get_obj_wear   args( ( CHAR_DATA *ch, char *argument ) );
OD *  get_obj_here   args( ( CHAR_DATA *ch, char *argument ) );
OD *  get_obj_world  args( ( CHAR_DATA *ch, char *argument ) );
OD *  create_money   args( ( int amount ) );
int   get_obj_number args( ( OBJ_DATA *obj ) );
int   get_obj_weight args( ( OBJ_DATA *obj ) );
bool  room_is_dark   args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool  room_is_private   args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool  can_see     args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool  can_see_obj args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool  can_drop_obj   args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
char *   item_type_name args( ( OBJ_DATA *obj ) );
char *   affect_loc_name   args( ( int location ) );
char *   affect_bit_name   args( ( int vector ) );
char *   extra_bit_name args( ( int extra_flags ) );
void  affect_modify  args( ( CHAR_DATA *ch, AFFECT_DATA *paf, bool fAdd ) );

/* interp.c */
void  interpret   args( ( CHAR_DATA *ch, char *argument ) );
bool  is_number   args( ( char *arg ) );
int   number_argument   args( ( char *argument, char *arg, int arglen ) );
char *   one_argument   args( ( char *argument, char *arg_first, int arglen ) );

/* magic.c */
int   skill_lookup   args( ( const char *name ) );
int   slot_lookup args( ( int slot ) );
bool  saves_spell args( ( int level, CHAR_DATA *victim ) );
void  obj_cast_spell args( ( int sn, int level, CHAR_DATA *ch,
					 CHAR_DATA *victim, OBJ_DATA *obj ) );

/* save.c */
void  save_char_obj  args( ( CHAR_DATA *ch ) );
bool  load_char_obj  args( ( DESCRIPTOR_DATA *d, char *name ) );
void    save_claninfo   args( ( void ) );
void    read_claninfo   args( ( void ) );
void    save_siteban_info  args( ( void ) );
void    read_siteban_info  args( ( void ) );
char *initial args( ( const char *str) );

/* special.c */
SF *  spec_lookup args( ( const char *name ) );

/* update.c */
void  advance_level  args( ( CHAR_DATA *ch ) );
void  gain_exp args( ( CHAR_DATA *ch, int gain ) );
void  gain_condition args( ( CHAR_DATA *ch, int iCond, int value ) );
void  update_handler args( ( void ) );

/* hunt.c */

/* joker.c */
bool longstring args( ( CHAR_DATA *ch, char *argument));
void do_clanitem args( ( CHAR_DATA *ch, char *argument));
void do_imminfo args( ( char *argument) );
void do_delete args( ( CHAR_DATA *ch, char *argument));
void do_backup args( ( CHAR_DATA *ch, char *argument));


#undef   CD
#undef   MID
#undef   OD
#undef   OID
#undef   RID
#undef   SF
