//
// Created by Svetodar on 20.09.2025.
//

#include "throwout.h"

#include "gameplay/fight/fight.h"
#include "engine/core/char_movement.h"
#include "engine/core/action_targeting.h"
#include "gameplay/fight/pk.h"
#include "gameplay/fight/common.h"
#include "gameplay/fight/fight_hit.h"

void DoThrowout(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->GetSkill(ESkill::kThrowout) < 1) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->HasCooldown(ESkill::kThrowout)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	one_argument(argument, arg);
	CharData *vict = FindVictim(ch, argument);

	if (!vict) {
		SendMsgToChar("    ,    ?\r\n", ch);
		return;
	}
	if (!IsAffectedBySpell(ch, ESpell::kFrenzy) && !IS_IMMORTAL(ch)) {
		SendMsgToChar(" !  ݣ   !\r\n", ch);
		return;
	}
	if (!may_kill_here(ch, vict, argument))
		return;
	if (!check_pkill(ch, vict, arg))
		return;
	if (NPC_FLAGGED(vict, ENpcFlag::kBlockDown)
		||NPC_FLAGGED(vict, ENpcFlag::kBlockUp)
		||NPC_FLAGGED(vict, ENpcFlag::kBlockNorth)
		||NPC_FLAGGED(vict, ENpcFlag::kBlockSouth)
		||NPC_FLAGGED(vict, ENpcFlag::kBlockEast)
		||NPC_FLAGGED(vict, ENpcFlag::kBlockWest)) {
			act("$N3  !",
			false, ch, nullptr,vict, kToChar);
		return;
	}
	if (!IS_IMMORTAL(ch) && ch->HasCooldown(ESkill::kThrowout)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->GetPosition() < EPosition::kFight) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (vict == ch) {
		SendMsgToChar("  ?!\r\n", ch);
		return;
	}
	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	GoThrowout(ch, vict);
}

void ProcessThrowoutFail(CharData *ch, CharData *vict) {
	act("&r    $N3!&n",
	false, ch, nullptr,vict, kToChar);
	act("$N $U   ,      !",
		false,vict, nullptr, ch, kToChar);
	act("$N $U  $n3 ,   $G   .",
		false,vict, nullptr, ch, kToNotVict | kToArenaListen);
	hit(vict, ch, ESkill::kUndefined, fight::kMainHand);
	SetSkillCooldown(ch, ESkill::kThrowout, 2);
}

void GoThrowout(CharData *ch, CharData *vict) {
//   30     75%  -  .
	int vict_hp_limit = 0.75 * vict->get_real_max_hit();
	if (!IS_IMMORTAL(ch) && GetRealLevel(vict) >= 30 && (vict->get_hit() > vict_hp_limit)) {
		act("    $N3 - $E ݣ  $G  $G!",
			false, ch, nullptr,vict, kToChar);
		return;
	}
	SkillRollResult result = MakeSkillTest(ch, ESkill::kThrowout, vict);
	bool success = result.success;

	if (!success) {
		ProcessThrowoutFail(ch, vict);
	} else {
		//  -,        .
		ActionTargeting::FoesRosterType roster{ch};
		for (const auto target: roster) {
			if (!target->IsNpc() && target != vict) {
				act("     ,       $N3!",
					false, ch, nullptr,target, kToChar);
				act("$N $U   $n3,   $G   .",
						false,vict, nullptr, ch, kToNotVict | kToArenaListen);
				hit(vict, ch, ESkill::kUndefined, fight::kMainHand);
				return;
			}
		}
		int cooldown_if_success = std::max(10, 20 - (ch->GetSkill(ESkill::kThrowout) / 25));
		EDirection direction = SelectRndDirection(vict, 0);
	    if (IsCorrectDirection(vict, direction, false, false)) {
    		act("&Y  $N3      !&Y&n",
				false, ch, nullptr,vict, kToChar);
	        act("&r$N $Q     $G !&n",
	            false, vict, nullptr, ch, kToChar);
	        act("$N $Q $n3    $G $s !",
	            false, vict, nullptr, ch, kToNotVict | kToArenaListen);
	    		if (vict->GetPosition() > EPosition::kSit) {
	    			vict->DropFromHorse();
	    			vict->SetPosition(EPosition::kSit);
	    			SetWait(vict, 2, false);
	    			SetSkillCooldown(ch, ESkill::kGlobalCooldown, 1);
	    		}
	    	stop_fighting(vict, true);
			PerformSimpleMove(vict, direction, false, nullptr, EMoveType::kThrowOut);
	    	if (!IS_IMMORTAL(ch)) {
	    		SetSkillCooldown(ch, ESkill::kThrowout, cooldown_if_success);
	    	}
	    } else if (!IsCorrectDirection(vict, direction, false, false)) {
			ProcessThrowoutFail(ch, vict);
	    }
	}
	TrainSkill(ch, ESkill::kThrowout, success, vict);
}