#include "engine/db/global_objects.h"
#include "engine/core/handler.h"

void DoRepair(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (!ch->GetSkill(ESkill::kRepair)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (IsTimedBySkill(ch, ESkill::kRepair)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	one_argument(argument, arg);

	if (ch->GetEnemy()) {
		SendMsgToChar("      !\r\n", ch);
		return;
	}

	if (!*arg) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}

	ObjData *obj;
	if (!(obj = get_obj_in_list_vis(ch, arg, ch->carrying))) {
		snprintf(buf, kMaxInputLength, "   \'%s\'.\r\n", arg);
		SendMsgToChar(buf, ch);
		return;
	};

	if (obj->get_maximum_durability() <= obj->get_current_durability()) {
		act("$o    .", false, ch, obj, nullptr, kToChar);
		return;
	}
	if ((obj->get_type() != EObjType::kWeapon) && !ObjSystem::is_armor_type(obj)) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}

	auto prob = number(1, MUD::Skills()[ESkill::kRepair].difficulty);
	auto percent = CalcCurrentSkill(ch, ESkill::kRepair, nullptr);
	TrainSkill(ch, ESkill::kRepair, prob <= percent, nullptr);
	if (prob > percent) {
		if (!percent) {
			percent = ch->GetSkill(ESkill::kRepair) / 10;
		}
		obj->set_current_durability(std::max(0, obj->get_current_durability() * percent / prob));
		if (obj->get_current_durability()) {
			act("   $o3,   $S  .",
				false, ch, obj, nullptr, kToChar);
			act("$n $u  $o3,  $g $S  .",
				false, ch, obj, nullptr, kToRoom | kToArenaListen);
			auto decay = (obj->get_maximum_durability() - obj->get_current_durability()) / 10;
			decay = std::clamp(decay, 1, obj->get_maximum_durability()/20);
			if (obj->get_maximum_durability() > decay) {
				obj->set_maximum_durability(obj->get_maximum_durability() - decay);
			} else {
				obj->set_maximum_durability(1);
			}
		} else {
			act("   $o3.",
				false, ch, obj, nullptr, kToChar);
			act("$n  $g $o3.",
				false, ch, obj, nullptr, kToRoom | kToArenaListen);
			ExtractObjFromWorld(obj);
		}
	} else {
		TimedSkill timed;
		timed.skill = ESkill::kRepair;
		auto modif = ch->GetSkill(ESkill::kRepair) / 7 + number(1, 5);
		timed.time = std::max(1, 25 - modif);
		ImposeTimedSkill(ch, &timed);
		obj->set_current_durability(std::min(obj->get_maximum_durability(), obj->get_current_durability() * percent / prob + 1));
		SendMsgToChar(ch, " %s %s .\r\n",
					  obj->get_PName(ECase::kNom).c_str(), GET_OBJ_POLY_1(ch, obj));
		act("$n  $g $o3.", false, ch, obj, nullptr, kToRoom | kToArenaListen);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
