#include "engine/entities/char_data.h"
#include "engine/core/handler.h"
#include "gameplay/mechanics/liquid.h"
#include "gameplay/mechanics/poison.h"
#include "engine/core/utils_char_obj.inl"

void DoPoisoning(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (!ch->GetSkill(ESkill::kPoisoning)) {
		SendMsgToChar("   .", ch);
		return;
	}

	argument = one_argument(argument, arg);
	skip_spaces(&argument);

	if (!*arg) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	} else if (!*argument) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}

	ObjData *weapon = nullptr;
	CharData *dummy = nullptr;
	int result = generic_find(arg, EFind::kObjInventory | EFind::kObjEquip, ch, &dummy, &weapon);

	if (!weapon || !result) {
		SendMsgToChar(ch, "   \'%s\'.\r\n", arg);
		return;
	} else if (weapon->get_type() != EObjType::kWeapon) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}

	ObjData *cont = get_obj_in_list_vis(ch, argument, ch->carrying);
	if (!cont) {
		SendMsgToChar(ch, "   \'%s\'.\r\n", argument);
		return;
	} else if (cont->get_type() != EObjType::kLiquidContainer) {
		SendMsgToChar(ch, "%s   .\r\n", cont->get_PName(ECase::kNom).c_str());
		return;
	} else if (GET_OBJ_VAL(cont, 1) <= 0) {
		SendMsgToChar(ch, " %s   .\r\n", cont->get_PName(ECase::kPre).c_str());
		return;
	} else if (!poison_in_vessel(GET_OBJ_VAL(cont, 2))) {
		SendMsgToChar(ch, " %s   .\r\n", cont->get_PName(ECase::kPre).c_str());
		return;
	}

	auto cost = std::min(GET_OBJ_VAL(cont, 1), GetRealLevel(ch) <= 10 ? 1 : GetRealLevel(ch) <= 20 ? 2 : 3);
	cont->set_val(1, cont->get_val(1) - cost);
	weight_change_object(cont, -cost);
	if (!GET_OBJ_VAL(cont, 1)) {
		name_from_drinkcon(cont);
	}

	set_weap_poison(weapon, cont->get_val(2));

	snprintf(buf, sizeof(buf), "    %s  $o3.", drinks[cont->get_val(2)]);
	act(buf, false, ch, weapon, nullptr, kToChar);
	act("$n  $q   $o3.",
		false, ch, weapon, nullptr, kToRoom | kToArenaListen);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
