#include "fit.h"

#include "engine/entities/char_data.h"
#include "engine/core/handler.h"

void DoFit(CharData *ch, char *argument, int/* cmd*/, int subcmd) {
	ObjData *obj;
	CharData *vict;
	char arg1[kMaxInputLength];
	char arg2[kMaxInputLength];

	if (GetRealLevel(ch) < kLvlImmortal) {
		SendMsgToChar("   .", ch);
		return;
	};

	if ((subcmd == kScmdDoAdapt) && !CanUseFeat(ch, EFeat::kToFitItem)) {
		SendMsgToChar("   .", ch);
		return;
	};
	if ((subcmd == kScmdMakeOver) && !CanUseFeat(ch, EFeat::kToFitClotches)) {
		SendMsgToChar("   .", ch);
		return;
	};

	argument = one_argument(argument, arg1);

	if (!*arg1) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	};

	if (!(obj = get_obj_in_list_vis(ch, arg1, ch->carrying))) {
		sprintf(buf, "   \'%s\'.\r\n", arg1);
		SendMsgToChar(buf, ch);
		return;
	};

	argument = one_argument(argument, arg2);
	if (!(vict = get_char_vis(ch, arg2, EFind::kCharInRoom))) {
		SendMsgToChar("      ?\r\n     !\r\n", ch);
		return;
	};

	if (obj->get_owner()) {
		SendMsgToChar("     .\r\n", ch);
		return;

	};

	if ((obj->get_wear_flags() <= 1) || obj->has_flag(EObjFlag::KSetItem)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	switch (subcmd) {
		case kScmdDoAdapt:
			if (obj->get_material() != EObjMaterial::kMaterialUndefined
				&& obj->get_material() != EObjMaterial::kBulat
				&& obj->get_material() != EObjMaterial::kBronze
				&& obj->get_material() != EObjMaterial::kIron
				&& obj->get_material() != EObjMaterial::kSteel
				&& obj->get_material() != EObjMaterial::kForgedSteel
				&& obj->get_material() != EObjMaterial::kPreciousMetel
				&& obj->get_material() != EObjMaterial::kWood
				&& obj->get_material() != EObjMaterial::kHardWood
				&& obj->get_material() != EObjMaterial::kGlass) {
				sprintf(buf, "  %s %s   .\r\n",
						obj->get_PName(ECase::kNom).c_str(), GET_OBJ_SUF_6(obj));
				SendMsgToChar(buf, ch);
				return;
			}
			break;
		case kScmdMakeOver:
			if (obj->get_material() != EObjMaterial::kBone
				&& obj->get_material() != EObjMaterial::kCloth
				&& obj->get_material() != EObjMaterial::kSkin
				&& obj->get_material() != EObjMaterial::kOrganic) {
				sprintf(buf, "  %s %s   .\r\n",
						obj->get_PName(ECase::kNom).c_str(), GET_OBJ_SUF_6(obj));
				SendMsgToChar(buf, ch);
				return;
			}
			break;
		default:
			SendMsgToChar(" - ...\r\n", ch);
			return;
	};
	obj->set_owner(vict->get_uid());
	sprintf(buf, "    ,     .\r\n");
	sprintf(buf + strlen(buf), "     10000  .\r\n");
	sprintf(buf + strlen(buf), " -  %s    %s.\r\n",
			obj->get_PName(ECase::kAcc).c_str(), GET_PAD(vict, 1));

	SendMsgToChar(buf, ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
