// $RCSfile$     $Date$     $Revision$
// Copyright (c) 2010 WorM
// Part of Bylins http://www.mud.ru

#ifndef NAMEDSTUFF_HPP_INCLUDED
#define NAMEDSTUFF_HPP_INCLUDED

#include "engine/core/conf.h"
#include "engine/core/sysdep.h"
#include "engine/ui/interpreter.h"

#include <unordered_map>

#define SCMD_NAMED_LIST    1
#define SCMD_NAMED_EDIT    2

namespace NamedStuff {

void do_named(CharData *ch, char *argument, int cmd, int subcmd);
void nedit_menu(CharData *ch);
bool parse_nedit_menu(CharData *ch, char *arg);

struct stuff_node {
	int uid;        // uid 
	std::string mail;    // e-mail    
	int can_clan;        //    
	int can_alli;        //    
	std::string wear_msg_v;    //     
	std::string wear_msg_a;    // --//--  
	std::string cant_msg_v;    //    /  
	std::string cant_msg_a;    // --//--  
};

//    
typedef std::shared_ptr<stuff_node> StuffNodePtr;
typedef std::unordered_map<long /* vnum  */, StuffNodePtr> StuffListType;

extern StuffListType stuff_list;

void save();
void load();
//     , simple     
//     check_anti_classes false- true-
bool check_named(CharData *ch, const ObjData *obj, const bool simple = false);
bool wear_msg(CharData *ch, ObjData *obj);
//     
void receive_items(CharData *ch, CharData *mailman);

} // namespace NamedStuff

#endif // NAMEDSTUFF_HPP_INCLUDED

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
