/**
\file damage.h - a part of the Bylins engine.
\authors Created by Sventovit.
\date 05.11.2025.
\brief Brief description.
\detail Detail description.
*/

#ifndef BYLINS_SRC_GAMEPLAY_FIGHT_DAMAGE_H_
#define BYLINS_SRC_GAMEPLAY_FIGHT_DAMAGE_H_

#include "gameplay/fight/fight_constants.h"
#include "gameplay/skills/skills.h"
#include "engine/entities/entities_constants.h"

#include <bitset>

/**
 *        :
 * Damage obj(SkillDmg(SKILL_NUM), dam, FightSystem::UNDEF_DMG|PHYS_DMG|MAGE_DMG)
 * obj.process(ch, victim);
 */
struct SkillDmg {
  explicit SkillDmg(ESkill id) : skill_id(id) {};
  ESkill skill_id;
};

/**
 *        :
 * Damage obj(SpellDmg(SPELL_NUM), dam, FightSystem::UNDEF_DMG|PHYS_DMG|MAGE_DMG)
 * obj.process(ch, victim);
 */
struct SpellDmg {
  explicit SpellDmg(ESpell spell_id) : spell_id(spell_id) {};
  ESpell spell_id;
};

/**
 *          (   messages):
 * Damage obj(SimpleDmg(TYPE_NUM), dam, FightSystem::UNDEF_DMG|PHYS_DMG|MAGE_DMG)
 * obj.process(ch, victim);
 */
struct SimpleDmg {
  explicit SimpleDmg(int num) : msg_num(num) {};
  int msg_num;
};

/**
 *  ,  :
 *   dam -  
 *   msg_num -    skill_num/spell_num/hit_type
 *   dmg_type - UNDEF_DMG/PHYS_DMG/MAGE_DMG
 *   :
 *   ch_start_pos -        ( )
 *   victim_start_pos -        (/ )
 */
class Damage {
 public:
  //    
  Damage() = default;

  // 
  Damage(SkillDmg obj, int in_dam, fight::DmgType in_dmg_type, ObjData *wielded_obj)
	  : dam(in_dam),
		dmg_type(in_dmg_type),
		skill_id(obj.skill_id),
		wielded(wielded_obj) {};

  // 
  Damage(SpellDmg obj, int in_dam, fight::DmgType in_dmg_type)
	  : dam(in_dam),
		dmg_type(in_dmg_type),
		spell_id(obj.spell_id) {};

  //  
  Damage(SimpleDmg obj, int in_dam, fight::DmgType in_dmg_type)
	  : dam(in_dam),
		dmg_type(in_dmg_type),
		msg_num(obj.msg_num) {};

  int Process(CharData *ch, CharData *victim);

  //  
  int dam{0};
  // flags[CRIT_HIT] = true, dam_critic = 0 -  
  // flags[CRIT_HIT] = true, dam_critic > 0 -   
  int dam_critic{0};
  //   (//)
  int dmg_type{-1};
  // .   HitData
  ESkill skill_id{ESkill::kUndefined};
  //  ,  >= 0
  ESpell spell_id{ESpell::kUndefined};
  //    .
  // ,   ,    .
  //   -     .
  EElement element{EElement::kUndefined};
  // .   HitData,     -1
  int hit_type{-1};
  //       messages
  //      process
  int msg_num{-1};
  //    HitType
  std::bitset<fight::kHitFlagsNum> flags;
  //      (   =  )
  EPosition ch_start_pos{EPosition::kUndefined};
  //      (   =  )
  EPosition victim_start_pos{EPosition::kUndefined};
  //    
  ObjData *wielded{nullptr};

 private:
  //       
  //  msg_num, ch_start_pos, victim_start_pos
  //    process,    
  void PerformPostInit(CharData *ch, CharData *victim);
  void SetPostInitShieldFlags(CharData *victim);
  // process()
  bool CalcMagisShieldsDmgAbsoption(CharData *ch, CharData *victim);
  void CalcArmorDmgAbsorption(CharData *victim);
  bool CalcDmgAbsorption(CharData *ch, CharData *victim);
  void ProcessDeath(CharData *ch, CharData *victim) const;
  void SendCritHitMsg(CharData *ch, CharData *victim);
  void SendDmgMsg(CharData *ch, CharData *victim) const;
  void ProcessBlink(CharData *ch, CharData *victim);

  //     
  int fs_damage{0};
  //     ,     
  //   flags   
  std::string brief_shields_;
};

#endif //BYLINS_SRC_GAMEPLAY_FIGHT_DAMAGE_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
