//  $RCSfile$     $Date$     $Revision$
//  Part of Bylins http://www.mud.ru
//              

#ifndef BIRTH_PLACES_HPP_INCLUDED
#define BIRTH_PLACES_HPP_INCLUDED

// ,      ,   .
const int kDefaultLoadroom = 4056;
const int kBirthplaceUndefined = -1;
#define BIRTH_PLACES_FILE "birthplaces.xml"
#define BIRTH_PLACE_NAME_UNDEFINED "Undefined:   - "
#define BIRTH_PLACE_MAIN_TAG "birthplaces"
#define BIRTH_PLACE_ERROR_STR "...birth places reading fail"

#include "engine/core/conf.h"
#include "engine/core/sysdep.h"
#include "engine/structs/structs.h"
#include "third_party_libs/pugixml/pugixml.h"

#include <vector>

class Birthplaces;

typedef std::shared_ptr<Birthplaces> BirthPlacePtr;
typedef std::vector<BirthPlacePtr> BirthPlaceListType;

class Birthplaces {
 public:
	static void Load(pugi::xml_node XMLBirthPlaceList);
	static int GetLoadRoom(int Id);                       //      ID
  [[maybe_unused]] static std::string GetMenuStr(int Id);                //      ID
	static std::vector<int> GetItemList(int Id);          //      ID
	static std::string ShowMenu(const std::vector<int> &BPList);   //      
	static int ParseSelect(const char *arg);                    //        (description)
	static bool CheckId(int Id);                          //      ID
	static int GetIdByRoom(int vnumum);                  //  ID   
	static std::string GetRentHelp(int Id);               //       ID

	//    .
	//   ,   
	[[nodiscard]] int Id() const { return this->id_; }
	std::string Name() { return this->name_; }
	std::string Description() { return this->description_; }
	std::string MenuStr() { return this->menu_str_; }
	[[nodiscard]] int LoadRoom() const { return this->load_room_; }
	[[nodiscard]] std::vector<int> ItemsList() const { return this->items_list_; }
	std::string RentHelp() { return this->rent_help_; }

 private:
	int id_;                                  //  -  
	std::string name_;                          //  
	std::string description_;                   //    
	std::string menu_str_;                       //   
	int load_room_;                              //   
	std::vector<int> items_list_;                //  ,        
	std::string rent_help_;                      // ,   -      

	static BirthPlaceListType BirthPlaceList;   //       
	static void LoadBirthPlace(pugi::xml_node BirthPlaceNode);  //     
	static BirthPlacePtr GetBirthPlaceById(int Id);           //        ID
};

#endif // BIRTH_PLACES_HPP_INCLUDED

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
