// Part of Bylins http://www.mud.ru

#ifndef _FIGHT_HIT_HPP_
#define _FIGHT_HIT_HPP_

#include "fight_constants.h"
#include "gameplay/affects/affect_handler.h"
#include "utils/utils.h"
#include "engine/core/conf.h"
#include "engine/core/sysdep.h"
#include "engine/structs/structs.h"
#include "fight.h"
#include "gameplay/mechanics/damage.h"

struct HitData {
	HitData() : weapon(fight::kMainHand), wielded(nullptr), weapon_pos(EEquipPos::kWield), weap_skill(ESkill::kUndefined),
				weap_skill_is(0), skill_num(ESkill::kUndefined), hit_type(0), hit_no_parry(false),
				ch_start_pos(EPosition::kUndefined), victim_start_pos(EPosition::kUndefined), victim_ac(0), calc_thaco(0),
				dam(0), dam_critic(0) {
		diceroll = number(100, 2099) / 100;
	};

	void Init(CharData *ch, CharData *victim);
	void CalcBaseHitroll(CharData *ch);
	void CalcCircumstantialHitroll(CharData *ch, CharData *victim);
	void CalcStaticHitroll(CharData *ch);
	void CalcCircumstantialAc(CharData *victim);
	void AddWeaponDmg(CharData *ch, bool need_dice = true);
	void AddBareHandsDmg(CharData *ch, bool need_dice = true);
	void ProcessDefensiveAbilities(CharData *ch, CharData *victim);
	void CalcCritHitChance(CharData *ch);
	int CalcDmg(CharData *ch, bool need_dice = true);
	int ProcessExtradamage(CharData *ch, CharData *victim);

	// init()
	// 1 -      (RIGHT_WEAPON),
	// 2 -    (LEFT_WEAPON)
	fight::AttackType weapon;
	// ,      
	ObjData *wielded;
	//   (NUM_WEARS) 
	int weapon_pos;
	//  ,      
	ESkill weap_skill;
	//   weap_skill  ,   train_skill (  )
	int weap_skill_is;
	//      
	int diceroll;
	//  ,    hit(),   kUndefined
	//    < 0 - ,     hit_type
	//  >= 0 - ,   
	ESkill skill_num;
	//      (attack_hit_text[])
	//       skill_num
	int hit_type;
	// true -   / /   ..
	bool hit_no_parry;
	//     
	EPosition ch_start_pos;
	//     
	EPosition victim_start_pos;

	//    
	//     
	int victim_ac;
	//     
	int calc_thaco;
	//  
	int dam;
	// flags[CRIT_HIT] = true, dam_critic = 0 -  
	// flags[CRIT_HIT] = true, dam_critic > 0 -   
	int dam_critic;

 public:
	using HitFlags = std::bitset<fight::kHitFlagsNum>;

	[[nodiscard]] const HitFlags &GetFlags() const { return m_flags; }
	void SetFlag(const size_t flag) { m_flags.set(flag); }
	void ResetFlag(const size_t flag) { m_flags.reset(flag); }
	static void CheckWeapFeats(const CharData *ch, ESkill weap_skill, int &calc_thaco, int &dam);
 private:
	// -  ,     damage()
	HitFlags m_flags;

  [[nodiscard]] Damage GenerateExtradamage(int initial_dmg);
};

void set_battle_pos(CharData *ch);
void ProcessExtrahits(CharData *ch, CharData *victim, ESkill type, fight::AttackType weapon);
void hit(CharData *ch, CharData *victim, ESkill type, fight::AttackType weapon);
int GetRealDamroll(CharData *ch);
int GetAutoattackDamroll(CharData *ch, int weapon_skill);

#endif // _FIGHT_HIT_HPP_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
