#ifndef _AFFECTHANDLER_HPP_
#define _AFFECTHANDLER_HPP_
#include "engine/entities/char_data.h"

//   
class AffectParent {
	// ,   
	CharData *ch;
	// ,    
	CharData *vict;
	//      
	int time;
	// ,  ,       
	const int freq;

 public:
	AffectParent(CharData *character, CharData *victim, int time, int frequency);
	void DoAffect();
};

//    Handler()
class DamageActorParameters {
 public:
	DamageActorParameters(CharData *act, CharData *vict, int dam) : ch(act), opponent(vict), damage(dam) {};
	CharData *ch;
	CharData *opponent;
	int damage;
};

class DamageVictimParameters {
 public:
	DamageVictimParameters(CharData *act, CharData *vict, int dam) : ch(vict), opponent(act), damage(dam) {};
	CharData *ch;
	CharData *opponent;
	int damage;
};

class BattleRoundParameters {
 public:
	BattleRoundParameters(CharData *actor) : ch(actor) {};
	CharData *ch;
};

class StopFightParameters {
 public:
	StopFightParameters(CharData *actor) : ch(actor) {};
	CharData *ch;
};
//   
class IAffectHandler {
 public:
	IAffectHandler(void) {};
	virtual ~IAffectHandler(void) {};
	virtual void Handle(DamageActorParameters &/* params*/) {};
	virtual void Handle(DamageVictimParameters &/* params*/) {};
	virtual void Handle(BattleRoundParameters &/* params*/) {};
	virtual void Handle(StopFightParameters &/* params*/) {};
};

class CombatLuckAffectHandler : public IAffectHandler {
 public:
	CombatLuckAffectHandler() : round_(0), damToMe_(false), damFromMe_(false) {};
	virtual ~CombatLuckAffectHandler() {};
	virtual void Handle(DamageActorParameters &params);
	virtual void Handle(BattleRoundParameters &params);
	virtual void Handle(DamageVictimParameters &params);
	virtual void Handle(StopFightParameters &params);
 private:
	int round_;
	bool damToMe_;
	bool damFromMe_;
};

template<class S>
void handle_affects(S &params) // params    
{
	for (const auto &aff : params.ch->affected) {
		if (aff->handler) {
			aff->handler->Handle(params); //    params   Handler
		}
	}
}

#endif

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
