/**
\authors Created by Sventovit
\date 30.05.2022.
\brief   .
*/

#ifndef BYLINS_SRC_FEATS_CONSTANTS_H_
#define BYLINS_SRC_FEATS_CONSTANTS_H_

#include "engine/structs/structs.h"
#include "engine/structs/meta_enum.h"

enum class EFeat {
	kUndefined = 0,			//DO NOT USE
	kBerserker = 1,				// 
	kParryArrow = 2,			// 
	kBlindFight = 3,			// 
	kImpregnable = 4,			//
	kNightVision = 5,			// 
	kDefender = 6,				//
	kDodger = 7,				//
	kLightWalk = 8,				// 
	kWriggler = 9,				//
	kSpellSubstitute = 10,		// 
	kPowerAttack = 11,			// 
	kWoodenSkin = 12,			// 
	kIronSkin = 13,				// 
	kConnoiseur = 14,			//
	kExorcist = 15,				// 
	kHealer = 16,				//
	kLightingReflex = 17,		// 
	kDrunkard = 18,				//
	kPowerMagic = 19,			// 
	kEndurance = 20,			//
	kGreatFortitude = 21,		// 
	kFastRegen = 22,			// 
	kStealthy = 23,				//
	kWolfScent = 24,			//  
	kSplendidHealth = 25,		// 
	kTracker = 26,				//
	kWeaponFinesse = 27,		// 
	kCombatCasting = 28,		// 
	kPunchMaster = 29,			// 
	kClubsMaster = 30,			// 
	kAxesMaster = 31,			// 
	kLongsMaster = 32,			// 
	kShortsMaster = 33,			// 
	kNonstandartsMaster = 34,	// 
	kTwohandsMaster = 35,		// 
	kPicksMaster = 36,			// 
	kSpadesMaster = 37,			// 
	kBowsMaster = 38,			// 
	kForestPath = 39,			// 
	kMountainPath = 40,			// 
	kLuckyGuy = 41,				//
	kWarriorSpirit = 42,		// 
	kReliableHealth = 43,		// 
	kExcellentMemory = 44,		// 
	kAnimalDextery = 45,		// 
	kLegibleWritting = 46,		// 
	kIronMuscles = 47,			// 
	kMagicSign = 48,			// 
	kGreatEndurance = 49,		//
	kBestDestiny = 50,			// 
	kHerbalist = 51,			//
	kJuggler = 52,				//
	kNimbleFingers = 53,		//
	kGreatPowerAttack = 54,		//  
	kStrongImmunity = 55,		//  
	kMobility = 56,				//
	kNaturalStr = 57,			//
	kNaturalDex = 58,			//
	kNaturalInt = 59,			// 
	kNaturalWis = 60,			//
	kNaturalCon = 61,			//
	kNaturalCha = 62,			// 
	kMnemonicEnhancer = 63,		// 
	kMagneticPersonality = 64,	//
	kDamrollBonus = 65,			//  
	kHitrollBonus = 66,			// 
	kInjure = 67,				//
	kPunchFocus = 68,			// :  
	kClubsFocus = 69,			// : 
	kAxesFocus = 70,			// : 
	kLongsFocus = 71,			// : 
	kShortsFocus = 72,			// : 
	kNonstandartsFocus = 73,	// : 
	kTwohandsFocus = 74,		// : 
	kPicksFocus = 75,			// : 
	kSpadesFocus = 76,			// : 
	kBowsFocus = 77,			// : 
	kAimingAttack = 78,			// 
	kGreatAimingAttack = 79,	//  
	kDoubleShot = 80,			// 
	kPorter = 81,				//
	kSecretRunes = 82,			// 
/*
,   .
	UNUSED = 83,
	UNUSED = 84,
	UNUSED = 85,
*/
	kToFitItem = 86,			//
	kToFitClotches = 87,		//
	kStrengthConcentration = 88,//  
	kDarkReading = 89,			//  
	kSpellCapabler = 90,		// 
	kWearingLightArmor = 91,	//    
	kWearingMediumArmor = 92,	//    
	kWearingHeavyArmor = 93,	//    
	kGemsInlay = 94,			//   (TODO:  )
	kWarriorStrength = 95,		//  
	kRelocate = 96,				// 
	kSilverTongue = 97,			//
	kBully = 98,				//
	kThieveStrike = 99,			// 
	kJeweller = 100,			// 
	kSkilledTrader = 101,		// 
	kZombieDrover = 102,		// 
	kEmployer = 103,			// 
	kMagicUser = 104,			// 
	kGoldTongue = 105,			//
	kCalmness = 106,			//
	kRetreat = 107,				//
	kShadowStrike = 108,		// 
	kThrifty = 109,				//
	kCynic = 110,				//
	kPartner = 111,				//
	kFavorOfDarkness = 112,		// 
	kFuryOfDarkness = 113,		// 
	kRegenOfDarkness = 114,		// 
	kSoulLink = 115,			// 
	kStrongClutch = 116,		// 
	kMagicArrows = 117,			// 
	kSoulsCollector = 118,		// 
	kDarkPact = 119,			// 
	kCorruption = 120,			//
	kHarvestOfLife = 121,		// 
	kLoyalAssist = 122,			// 
	kHauntingSpirit = 123,		// 
	kSnakeRage = 124,			// 

//	UNUSED = 125,

	kElderTaskmaster = 126,		// 
	kLordOfUndeads = 127,		// 
	kWarlock = 128,				// 
	kElderPriest = 129,			// 
	kHighLich = 130,			// 
	kDarkRitual = 131,			// 
	kTeamsterOfUndead = 132,	// 
	kScirmisher = 133,			// 
	kTactician = 134,			//
	kLiveShield = 135,			//

/*
  

	RESERVED = 132,		//
	RESERVED = 133,		//
	RESERVED = 134,		//
	RESERVED = 135,		//
	RESERVED = 136,		//
*/
	kSerratedBlade = 137,		// 
	kEvasion = 138,				// 
	kCutting = 139,				//
	kFInesseShot = 140,			// 
	kObjectEnchanter = 141,		// 
	kDeftShooter = 142,			// 
	kMagicShooter = 143,		// 

	// UNUSED = 144,			//

	kShadowThrower = 145,		// 
	kShadowDagger = 146,		// 
	kShadowSpear = 147,			// 
	kShadowClub = 148,			// 
	kDoubleThrower = 149,		// 
	kTripleThrower = 150,		// 
	kPowerThrow = 151,			//
	kDeadlyThrow = 152,			// 

	//UNUSED = 153,			//

	kMultipleCast = 154,		//      
	kMagicalShield = 155,		//    
	kAnimalMaster = 156,		// 
	kSlashMaster = 157, 		//  
	kPhysicians = 158,
	kFirst = kBerserker,
	kLast = kPhysicians				// !!!    !!!
};

template<>
const std::string &NAME_BY_ITEM<EFeat>(EFeat item);
template<>
EFeat ITEM_BY_NAME<EFeat>(const std::string &name);

EFeat& operator++(EFeat &f);

const int kLastFeatSlotLvl = 28;		//        .
const int kMinBaseFeatsSlotsAmount = 1;	//       0 
const int kMaxBaseFeatsSlotsAmount = 6;	//       0 .

#endif //BYLINS_SRC_FEATS_CONSTANTS_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
