/**
\file do_unfreeze.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 27.10.2025.
\brief Brief description.
\detail Detail description.
*/

#include "administration/punishments.h"
#include "engine/entities/char_data.h"
#include "engine/entities/char_player.h"

#include <fstream>
#include <iostream>

void DoUnfreeze(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	/*  unfreeze.lst
	  email
	     
	     */
	//char email[50], reason[50];
	Player t_vict;
	CharData *vict;
	char *reason_c; //   set_punish,      string :(
	std::string email;
	std::string reason;
	std::string name_buffer;
	std::ifstream unfreeze_list;
	unfreeze_list.open("../lib/misc/unfreeze.lst", std::fstream::in);
	if (!unfreeze_list) {
		SendMsgToChar(" unfreeze.lst !\r\n", ch);
		return;
	}
	unfreeze_list >> email;
	unfreeze_list >> reason;
	sprintf(buf, " .\r\nEmail:%s\r\n:%s\r\n", email.c_str(), reason.c_str());
	SendMsgToChar(buf, ch);
	reason_c = new char[reason.length() + 1];
	strcpy(reason_c, reason.c_str());

	while (!unfreeze_list.eof()) {
		unfreeze_list >> name_buffer;
		if (LoadPlayerCharacter(name_buffer.c_str(), &t_vict, ELoadCharFlags::kFindId) < 0) {
			sprintf(buf, "   %s   !\r\n", name_buffer.c_str());
			SendMsgToChar(buf, ch);
			continue;
		}
		vict = &t_vict;
		if (GET_EMAIL(vict) != email) {
			sprintf(buf, "  %s  .\r\n", name_buffer.c_str());
			SendMsgToChar(buf, ch);
			continue;
		}
		punishments::SetFreeze(ch, vict, reason_c, 0);
		vict->save_char();
		sprintf(buf, " %s .\r\n", name_buffer.c_str());
		SendMsgToChar(buf, ch);
	}

	delete[] reason_c;
	unfreeze_list.close();

}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
