/**
\file do_visible.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 19.09.2024.
\brief Brief description.
\detail Detail description.
*/

#include "engine/ui/cmd/do_visible.h"

#include "engine/entities/char_data.h"
#include "gameplay/mechanics/sight.h"

void do_visible(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (IS_IMMORTAL(ch)) {
		perform_immort_vis(ch);
		return;
	}

	if (AFF_FLAGGED(ch, EAffect::kInvisible)
		|| AFF_FLAGGED(ch, EAffect::kDisguise)
		|| AFF_FLAGGED(ch, EAffect::kHide)
		|| AFF_FLAGGED(ch, EAffect::kSneak)) {
		Appear(ch);
		SendMsgToChar("   .\r\n", ch);
	} else
		SendMsgToChar("   .\r\n", ch);
}

void perform_immort_vis(CharData *ch) {
	if (GET_INVIS_LEV(ch) == 0 &&
		!AFF_FLAGGED(ch, EAffect::kHide) && !AFF_FLAGGED(ch, EAffect::kInvisible)
		&& !AFF_FLAGGED(ch, EAffect::kDisguise)) {
		SendMsgToChar("    .      ?\r\n", ch);
		return;
	}

	SET_INVIS_LEV(ch, 0);
	Appear(ch);
	SendMsgToChar("   .\r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
