/**
\file sleep.cpp - a part of Bylins engine.
\authors Created by Sventovit.
\date 08.09.2024.
\brief 'Do sleep' command.
*/

#include "engine/entities/char_data.h"

void do_sleep(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (GetRealLevel(ch) >= kLvlImmortal) {
		SendMsgToChar("   ,   !\r\n", ch);
		return;
	}
	if (ch->IsOnHorse()) {
		act(" ,     $N1.", false, ch, nullptr, ch->get_horse(), kToChar);
		return;
	}
	switch (ch->GetPosition()) {
		case EPosition::kStand:
		case EPosition::kSit:
		case EPosition::kRest: SendMsgToChar(" .\r\n", ch);
			act("$n  $g  $g .", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->SetPosition(EPosition::kSleep);
			break;
		case EPosition::kSleep: SendMsgToChar("    .\r\n", ch);
			break;
		case EPosition::kFight: SendMsgToChar("  !   .\r\n", ch);
			break;
		default: SendMsgToChar("       .\r\n", ch);
			act("$n $g    $g.", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->SetPosition(EPosition::kSleep);
			break;
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
