/**
\file do_sit.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 24.09.2024.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"

void do_sit(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsOnHorse()) {
		act(" ,     $N1.", false, ch, nullptr, ch->get_horse(), kToChar);
		return;
	}
	switch (ch->GetPosition()) {
		case EPosition::kStand: SendMsgToChar(" .\r\n", ch);
			act("$n $g.", false, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->SetPosition(EPosition::kSit);
			break;
		case EPosition::kSit: SendMsgToChar("    .\r\n", ch);
			break;
		case EPosition::kRest: SendMsgToChar("    .\r\n", ch);
			act("$n $g   $g.", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->SetPosition(EPosition::kSit);
			break;
		case EPosition::kSleep: SendMsgToChar("  .\r\n", ch);
			break;
		case EPosition::kFight: SendMsgToChar("?   ?     .\r\n", ch);
			break;
		default: SendMsgToChar("     .\r\n", ch);
			act("$n $g    $g.", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->SetPosition(EPosition::kSit);
			break;
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
