#include "do_retreat.h"
#include "gameplay/fight/fight.h"

// ***************** STOPFIGHT
void do_retreat(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (!ch->GetEnemy() || ch->IsNpc()) {
		SendMsgToChar("       .\r\n", ch);
		return;
	}

	if (ch->GetPosition() < EPosition::kFight) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	if (ch->IsFlagged(EPrf::kIronWind) || AFF_FLAGGED(ch, EAffect::kCombatLuck)) {
		SendMsgToChar("   ,     !\r\n", ch);
		return;
	}

	CharData *tmp_ch = nullptr;
	for (const auto i : world[ch->in_room]->people) {
		if (i->GetEnemy() == ch) {
			tmp_ch = i;
			break;
		}
	}

	if (tmp_ch) {
		SendMsgToChar(",     .\r\n", ch);
		return;
	} else {
		stop_fighting(ch, true);
		if (!(IS_IMMORTAL(ch) || GET_GOD_FLAG(ch, EGf::kGodsLike)))
			SetWaitState(ch, kBattleRound);
		SendMsgToChar("   .\r\n", ch);
		act("$n $g  .", false, ch, 0, 0, kToRoom | kToArenaListen);
	}
}