#include "do_order.h"

#include "engine/core/handler.h"

// ****************** CHARM ORDERS PROCEDURES
void do_order(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	char name[kMaxInputLength], message[kMaxInputLength];
	bool found = false;
	RoomRnum org_room;
	CharData *vict;

	if (!ch)
		return;

	half_chop(argument, name, message);
	if (GET_GOD_FLAG(ch, EGf::kGodscurse)) {
		SendMsgToChar("       !\r\n", ch);
		return;
	}
	if (AFF_FLAGGED(ch, EAffect::kSilence)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (!*name || !*message)
		SendMsgToChar("   ?\r\n", ch);
	else if (!(vict = get_char_vis(ch, name, EFind::kCharInRoom)) &&
		!utils::IsAbbr(name, "followers") && !utils::IsAbbr(name, "") && !utils::IsAbbr(name, ""))
		SendMsgToChar("    .\r\n", ch);
	else if (ch == vict && !utils::IsAbbr(name, "") && !utils::IsAbbr(name, ""))
		SendMsgToChar("     -   !\r\n", ch);
	else {
		if (vict && !vict->IsNpc() && !IS_GOD(ch)) {
			SendMsgToChar(ch, "    !\r\n");
			return;
		}

		if (AFF_FLAGGED(ch, EAffect::kCharmed)) {
			SendMsgToChar("        .\r\n", ch);
			return;
		}

		if (vict
			&& !utils::IsAbbr(name, "")
			&& !utils::IsAbbr(name, "")
			&& !utils::IsAbbr(name, "followers")) {
			sprintf(buf, "$N $g  '%s'", message);
			act(buf, false, vict, 0, ch, kToChar | kToNotDeaf);
			act("$n $g  $N2.", false, ch, 0, vict, kToRoom | kToNotDeaf);

			if (vict->get_master() != ch
				|| !(AFF_FLAGGED(vict, EAffect::kCharmed) || AFF_FLAGGED(vict, EAffect::kHelper))
				|| AFF_FLAGGED(vict, EAffect::kDeafness)) {
				if (!IS_POLY(vict)) {
					act("$n    .", false, vict, 0, 0, kToRoom);
				} else {
					act("$n    .", false, vict, 0, 0, kToRoom);
				}
			} else {
				SendMsgToChar(OK, ch);
				if (vict->get_wait() <= 0) {
					command_interpreter(vict, message);
				} else if (vict->GetEnemy()) {
					vict->last_comm = message;
				}
			}
		} else {
			org_room = ch->in_room;
			act("$n $g .", false, ch, 0, 0, kToRoom | kToNotDeaf);

			CharData::followers_list_t followers = ch->get_followers_list();

			for (const auto follower : followers) {
				if (org_room != follower->in_room) {
					continue;
				}

				if ((AFF_FLAGGED(follower, EAffect::kCharmed) || AFF_FLAGGED(follower, EAffect::kHelper))
					&& !AFF_FLAGGED(follower, EAffect::kDeafness)) {
					found = true;
					if (follower->get_wait() <= 0) {
						command_interpreter(follower, message);
					} else if (follower->GetEnemy()) {
						follower->last_comm = message;
					}
				}
			}

			if (found) {
				SendMsgToChar(OK, ch);
			} else {
				SendMsgToChar("   !\r\n", ch);
			}
		}
	}
}
