/**
\file listen.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 11.09.2024.
\brief description.
*/

#include "engine/entities/char_data.h"
#include "engine/ui/color.h"
#include "gameplay/mechanics/sight.h"
#include "engine/db/global_objects.h"
#include "engine/core/handler.h"

void hear_in_direction(CharData *ch, int dir, int info_is);

void DoListen(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	int i;

	if (!ch->desc)
		return;

	if (AFF_FLAGGED(ch, EAffect::kDeafness)) {
		SendMsgToChar("       .\r\n", ch);
		return;
	}

	if (ch->GetPosition() < EPosition::kSleep)
		SendMsgToChar("    ,    .\r\n", ch);
	if (ch->GetPosition() == EPosition::kSleep)
		SendMsgToChar("         .\r\n", ch);
	else if (ch->GetSkill(ESkill::kHearing)) {
		if (check_moves(ch, kHearingMoves)) {
			SendMsgToChar("   .\r\n", ch);
			for (i = 0; i < EDirection::kMaxDirNum; i++)
				hear_in_direction(ch, i, 0);
			if (!(IS_IMMORTAL(ch) || GET_GOD_FLAG(ch, EGf::kGodsLike)))
				SetWaitState(ch, 1 * kBattleRound);
		}
	} else
		SendMsgToChar("     .\r\n", ch);
}

void hear_in_direction(CharData *ch, int dir, int info_is) {
	int count = 0, percent = 0, probe = 0;
	RoomData::exit_data_ptr rdata;
	int fight_count = 0;
	std::string tmpstr;

	if (AFF_FLAGGED(ch, EAffect::kDeafness)) {
		SendMsgToChar(" ,   ?\r\n", ch);
		return;
	}
	if (CAN_GO(ch, dir)
		|| (EXIT(ch, dir)
			&& EXIT(ch, dir)->to_room() != kNowhere)) {
		rdata = EXIT(ch, dir);
		count += sprintf(buf, "%s%s:%s ", kColorYel, dirs_rus[dir], kColorNrm);
		count += sprintf(buf + count, "\r\n%s", kColorGrn);
		SendMsgToChar(buf, ch);
		count = 0;
		for (const auto tch : world[rdata->to_room()]->people) {
			percent = number(1, MUD::Skill(ESkill::kHearing).difficulty);
			probe = CalcCurrentSkill(ch, ESkill::kHearing, tch);
			TrainSkill(ch, ESkill::kHearing, probe >= percent, tch);
			//      .
			if (tch->GetEnemy()) {
				if (tch->IsNpc()) {
					tmpstr += "    - .\r\n";
				} else {
					tmpstr += "    - .\r\n";
				}
				fight_count++;
				continue;
			}

			if ((probe >= percent
				|| ((!AFF_FLAGGED(tch, EAffect::kSneak) || !AFF_FLAGGED(tch, EAffect::kHide))
					&& (probe > percent * 2)))
				&& (percent < 100 || IS_IMMORTAL(ch))
				&& !fight_count) {
				if (tch->IsNpc()) {
					if (GET_RACE(tch) == ENpcRace::kConstruct) {
						if (GetRealLevel(tch) < 5)
							tmpstr += "   -  .\r\n";
						else if (GetRealLevel(tch) < 15)
							tmpstr += "   - .\r\n";
						else if (GetRealLevel(tch) < 25)
							tmpstr += "   -  .\r\n";
						else
							tmpstr += "   -  .\r\n";
					} else if (real_sector(ch->in_room) != ESector::kUnderwater) {
						if (GetRealLevel(tch) < 5)
							tmpstr += "   -  .\r\n";
						else if (GetRealLevel(tch) < 15)
							tmpstr += "   - .\r\n";
						else if (GetRealLevel(tch) < 25)
							tmpstr += "   -  .\r\n";
						else
							tmpstr += "   -  .\r\n";
					} else {
						if (GetRealLevel(tch) < 5)
							tmpstr += "    .\r\n";
						else if (GetRealLevel(tch) < 15)
							tmpstr += "   .\r\n";
						else if (GetRealLevel(tch) < 25)
							tmpstr += "    .\r\n";
						else
							tmpstr += "    .\r\n";
					}
				} else {
					tmpstr += "   - .\r\n";
				}
				count++;
			}
		}

		if ((!count) && (!fight_count)) {
			SendMsgToChar("   .\r\n", ch);
		} else {
			SendMsgToChar(tmpstr.c_str(), ch);
		}

		SendMsgToChar(kColorNrm, ch);
	} else {
		if (info_is & EXIT_SHOW_WALL) {
			SendMsgToChar("     ?\r\n", ch);
		}
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
