#include "do_kill.h"

#include "gameplay/fight/fight.h"
#include "gameplay/fight/pk.h"
#include "gameplay/fight/fight_hit.h"
#include "gameplay/skills/protect.h"
#include "gameplay/fight/common.h"

void DoHit(CharData *ch, char *argument, int/* cmd*/, int subcmd) {
	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (vict == ch) {
		SendMsgToChar("  ...   !\r\n", ch);
		act("$n $g ,   $g ',  ...'",
			false,
			ch,
			0,
			vict,
			kToRoom | kToNotDeaf | kToArenaListen);
		act("$n $g ", false, ch, 0, vict, kToRoom | kToDeaf | kToArenaListen);
		return;
	}
	if (!may_kill_here(ch, vict, argument)) {
		return;
	}
	if (AFF_FLAGGED(ch, EAffect::kCharmed) && (ch->get_master() == vict)) {
		act("$N    ,   $S.", false, ch, 0, vict, kToChar);
		return;
	}

	if (subcmd != kScmdMurder && !check_pkill(ch, vict, arg)) {
		return;
	}

	if (ch->GetEnemy()) {
		if (vict == ch->GetEnemy()) {
			act("    $N4.", false, ch, 0, vict, kToChar);
			return;
		}
		if (ch != vict->GetEnemy()) {
			act("$N    ,   $S.", false, ch, 0, vict, kToChar);
			return;
		}
		vict = TryToFindProtector(vict, ch);
		stop_fighting(ch, 2);
		SetFighting(ch, vict);
		SetWait(ch, 2, true);
		//ch->setSkillCooldown(kGlobalCooldown, 2);
		return;
	}
	if ((ch->GetPosition() == EPosition::kStand) && (vict != ch->GetEnemy())) {
		set_hit(ch, vict);
	} else {
		SendMsgToChar("    !\r\n", ch);
	}
}

void DoKill(CharData *ch, char *argument, int cmd, int subcmd) {
	if (!IS_GRGOD(ch)) {
		DoHit(ch, argument, cmd, subcmd);
		return;
	};
	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("    -?\r\n", ch);
		return;
	}
	if (ch == vict) {
		SendMsgToChar(" ... :(\r\n", ch);
		return;
	};
	if (IS_IMPL(vict) || vict->IsFlagged(EPrf::kCoderinfo)) {
		SendMsgToChar("     ? , , !\r\n", ch);
	} else {
		act("  $N3  ! ! !", false, ch, 0, vict, kToChar);
		act("$N $g      !", false, vict, 0, ch, kToChar);
		act("$n  $g  $N3!", false, ch, 0, vict, kToNotVict | kToArenaListen);
		raw_kill(vict, ch);
	};
};
