#include "gameplay/mechanics/depot.h"
#include "engine/entities/char_data.h"
#include "gameplay/fight/pk.h"
#include "engine/core/handler.h"
#include "gameplay/clans/house.h"
#include "engine/core/utils_char_obj.inl"
#include "gameplay/economics/currencies.h"
#include "gameplay/mechanics/groups.h"

#include <third_party_libs/fmt/include/fmt/format.h>

extern bool CanTakeObj(CharData *ch, ObjData *obj);
extern char *find_exdesc(const char *word, const ExtraDescription::shared_ptr &list);

///    ch     ( )
int other_pc_in_group(CharData *ch) {
	int num = 0;
	CharData *k = ch->has_master() ? ch->get_master() : ch;
	for (FollowerType *f = k->followers; f; f = f->next) {
		if (AFF_FLAGGED(f->follower, EAffect::kGroup)
			&& !f->follower->IsNpc()
			&& f->follower->in_room == ch->in_room) {
			++num;
		}
	}
	return num;
}

void split_or_clan_tax(CharData *ch, long amount) {
	if (AFF_FLAGGED(ch, EAffect::kGroup) && (other_pc_in_group(ch) > 0) &&
		ch->IsFlagged(EPrf::kAutosplit)) {
		char buf_[kMaxInputLength];
		snprintf(buf_, sizeof(buf_), "%ld", amount);
		group::do_split(ch, buf_, 0, 0);
	} else {
		long tax = ClanSystem::do_gold_tax(ch, amount);
		ch->remove_gold(tax);
	}
}

void get_check_money(CharData *ch, ObjData *obj, ObjData *cont) {

	if (system_obj::is_purse(obj) && GET_OBJ_VAL(obj, 3) == ch->get_uid()) {
		system_obj::process_open_purse(ch, obj);
		return;
	}

	const int value = GET_OBJ_VAL(obj, 0);
	const int curr_type = GET_OBJ_VAL(obj, 1);

	if (obj->get_type() != EObjType::kMoney || value <= 0) {
		return;
	}

	if (curr_type == currency::ICE) {
		sprintf(buf, "  %d %s.\r\n", value, GetDeclensionInNumber(value, EWhat::kIceU));
		SendMsgToChar(buf, ch);
		ch->add_ice_currency(value);
		//  !
		if (AFF_FLAGGED(ch, EAffect::kGroup) && other_pc_in_group(ch) > 0) {
			char local_buf[256];
			sprintf(local_buf, "%d", value);
			group::do_split(ch, local_buf, 0, 0, curr_type);
		}
		ExtractObjFromWorld(obj);
		return;
	}

//    -  ( )
/*	if (curr_type != currency::GOLD) {
		//   
		return;
	}
*/
	sprintf(buf, "  %d %s.\r\n", value, GetDeclensionInNumber(value, EWhat::kMoneyU));
	SendMsgToChar(buf, ch);
	if (InTestZone(ch)) {
		ExtractObjFromWorld(obj);
		return;
	}
	// ,     -    (   )
	if (AFF_FLAGGED(ch, EAffect::kGroup) && other_pc_in_group(ch) > 0 &&
		ch->IsFlagged(EPrf::kAutosplit) && (!cont || !system_obj::is_purse(cont))) {
		//  ,   , - 
		//        do_split()
		ch->add_gold(value);
		sprintf(buf,
				"<%s> {%d}  %d %s  .",
				ch->get_name().c_str(),
				GET_ROOM_VNUM(ch->in_room),
				value,
				GetDeclensionInNumber(value, EWhat::kMoneyU));
		mudlog(buf, NRM, kLvlGreatGod, MONEY_LOG, true);
		char local_buf[256];
		sprintf(local_buf, "%d", value);
		group::do_split(ch, local_buf, 0, 0);
	} else if (cont && system_obj::is_purse(cont)) {
		//    
		//   , ..   
		//    cont    
		sprintf(buf, "%s    : %d  %s.", ch->get_name().c_str(), value,
				GetDeclensionInNumber(value, EWhat::kMoneyU));
		mudlog(buf, NRM, kLvlGreatGod, MONEY_LOG, true);
		ch->add_gold(value);
	} else if ((cont && IS_MOB_CORPSE(cont)) || GET_OBJ_VNUM(obj) != -1) {
		//       -  
		// (-  ) -  -
		sprintf(buf, "%s  %d  %s.", ch->get_name().c_str(), value,
				GetDeclensionInNumber(value, EWhat::kMoneyU));
		mudlog(buf, NRM, kLvlGreatGod, MONEY_LOG, true);
		ch->add_gold(value, true, true);
	} else {
		sprintf(buf,
				"<%s> {%d} -  %d  %s.",
				ch->get_name().c_str(),
				GET_ROOM_VNUM(ch->in_room),
				value,
				GetDeclensionInNumber(value, EWhat::kMoneyU));
		mudlog(buf, NRM, kLvlGreatGod, MONEY_LOG, true);
		ch->add_gold(value);
	}
	RemoveObjFromChar(obj);
	ExtractObjFromWorld(obj);
}

// return 0 -      -,
//          ,  
bool perform_get_from_container(CharData *ch, ObjData *obj, ObjData *cont, int mode) {
	if (!bloody::handle_transfer(nullptr, ch, obj))
		return false;
	if ((mode == EFind::kObjInventory || mode == EFind::kObjRoom || mode == EFind::kObjEquip) && CanTakeObj(ch, obj)
		&& get_otrigger(obj, ch)) {
		//    -
		if (Clan::is_clan_chest(cont)) {
			if (!Clan::TakeChest(ch, obj, cont)) {
				return false;
			}
			return true;
		}
		// - 
		if (ClanSystem::is_ingr_chest(cont)) {
			if (!Clan::take_ingr_chest(ch, obj, cont)) {
				return false;
			}
			return true;
		}
		RemoveObjFromObj(obj);
		PlaceObjToInventory(obj, ch);
		if (obj->get_carried_by() == ch) {
			if (bloody::is_bloody(obj)) {
				act("  $o3  $O1,    !", false, ch, obj, cont, kToChar);
				act("$n $g $o3  $O1,   .", true, ch, obj, cont, kToRoom | kToArenaListen);
			} else {
				act("  $o3  $O1.", false, ch, obj, cont, kToChar);
				act("$n $g $o3  $O1.", true, ch, obj, cont, kToRoom | kToArenaListen);
			}
			get_check_money(ch, obj, cont);
		}
	}
	return true;
}

// *\param autoloot - true         
void get_from_container(CharData *ch, ObjData *cont, char *local_arg, int mode, int amount, bool autoloot) {
	if (Depot::is_depot(cont)) {
		Depot::take_depot(ch, local_arg, amount);
		return;
	}

	ObjData *obj, *next_obj;
	int obj_dotmode, found = 0;

	obj_dotmode = find_all_dots(local_arg);
	if (OBJVAL_FLAGGED(cont, EContainerFlag::kShutted))
		act("$o $A.", false, ch, cont, nullptr, kToChar);
	else if (obj_dotmode == kFindIndiv) {
		if (!(obj = get_obj_in_list_vis(ch, local_arg, cont->get_contains()))) {
			sprintf(buf, "   '%s'  $o5.", local_arg);
			act(buf, false, ch, cont, nullptr, kToChar);
		} else {
			ObjData *obj_next;
			while (obj && amount--) {
				obj_next = obj->get_next_content();
				if (!perform_get_from_container(ch, obj, cont, mode))
					return;
				obj = get_obj_in_list_vis(ch, local_arg, obj_next);
			}
		}
	} else {
		if (obj_dotmode == kFindAlldot && !*local_arg) {
			SendMsgToChar("  \"\"?\r\n", ch);
			return;
		}
		for (obj = cont->get_contains(); obj; obj = next_obj) {
			next_obj = obj->get_next_content();
			if (CAN_SEE_OBJ(ch, obj)
				&& (obj_dotmode == kFindAll
					|| isname(local_arg, obj->get_aliases())
					|| CHECK_CUSTOM_LABEL(local_arg, obj, ch))) {
				if (autoloot
					&& (obj->get_type() == EObjType::kIngredient
						|| obj->get_type() == EObjType::kMagicIngredient)
					&& ch->IsFlagged(EPrf::kNoIngrLoot)) {
					continue;
				}
				found = 1;
				if (!perform_get_from_container(ch, obj, cont, mode)) {
					return;
				}
			}
		}
		if (!found) {
			if (obj_dotmode == kFindAll)
				act("$o $A.", false, ch, cont, nullptr, kToChar);
			else {
				sprintf(buf, "      '%s'  $o5.", local_arg);
				act(buf, false, ch, cont, nullptr, kToChar);
			}
		}
	}
}

int perform_get_from_room(CharData *ch, ObjData *obj) {
	if (CanTakeObj(ch, obj) && get_otrigger(obj, ch) && bloody::handle_transfer(nullptr, ch, obj)) {
		RemoveObjFromRoom(obj);
		PlaceObjToInventory(obj, ch);
		if (obj->get_carried_by() == ch) {
			if (bloody::is_bloody(obj)) {
				act("  $o3,    !",
					false, ch, obj, nullptr, kToChar);
				act("$n $g $o3,   .",
					true, ch, obj, nullptr, kToRoom | kToArenaListen);
			} else {
				act("  $o3.", false, ch, obj, nullptr, kToChar);
				act("$n $g $o3.", true, ch, obj, nullptr, kToRoom | kToArenaListen);
			}
			get_check_money(ch, obj, nullptr);
			return (1);
		}
	}
	return (0);
}

void get_from_room(CharData *ch, char *local_arg, int howmany) {
	ObjData *obj, *next_obj;
	int dotmode, found = 0;

	// Are they trying to take something in a room extra description?
	if (find_exdesc(local_arg, world[ch->in_room]->ex_description) != nullptr) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	dotmode = find_all_dots(local_arg);

	if (dotmode == kFindIndiv) {
		if (!(obj = get_obj_in_list_vis(ch, local_arg, world[ch->in_room]->contents))) {
			sprintf(buf, "    '%s'.\r\n", local_arg);
			SendMsgToChar(buf, ch);
		} else {
			ObjData *obj_next;
			while (obj && howmany--) {
				obj_next = obj->get_next_content();
				perform_get_from_room(ch, obj);
				obj = get_obj_in_list_vis(ch, local_arg, obj_next);
			}
		}
	} else {
		if (dotmode == kFindAlldot && !*local_arg) {
			SendMsgToChar("  \"\"?\r\n", ch);
			return;
		}
		for (obj = world[ch->in_room]->contents; obj; obj = next_obj) {
			next_obj = obj->get_next_content();
			if (CAN_SEE_OBJ(ch, obj)
				&& (dotmode == kFindAll
					|| isname(local_arg, obj->get_aliases())
					|| CHECK_CUSTOM_LABEL(local_arg, obj, ch))) {
				found = 1;
				perform_get_from_room(ch, obj);
			}
		}
		if (!found) {
			if (dotmode == kFindAll) {
				SendMsgToChar(",   .\r\n", ch);
			} else {
				sprintf(buf, "    '%s'.\r\n", local_arg);
				SendMsgToChar(buf, ch);
			}
		}
	}
}

void do_get(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	char arg1[kMaxInputLength];
	char arg2[kMaxInputLength];
	char arg3[kMaxInputLength];
	char arg4[kMaxInputLength];
	char *theobj, *thecont, *theplace;
	int where_bits = EFind::kObjInventory | EFind::kObjEquip | EFind::kObjRoom;

	int cont_dotmode, found = 0, mode, amount = 1;
	ObjData *cont;
	CharData *tmp_char;

	argument = two_arguments(argument, arg1, arg2);
	argument = two_arguments(argument, arg3, arg4);

	if (ch->GetCarryingQuantity() >= CAN_CARRY_N(ch))
		SendMsgToChar("   !\r\n", ch);
	else if (!*arg1)
		SendMsgToChar("   ?\r\n", ch);
	else if (!*arg2 || isname(arg2, "  ground room"))
		get_from_room(ch, arg1, 1);
	else if (is_number(arg1) && (!*arg3 || isname(arg3, "  ground room")))
		get_from_room(ch, arg2, atoi(arg1));
	else if ((!*arg3 && isname(arg2, "  inventory equipment")) ||
		(is_number(arg1) && !*arg4 && isname(arg3, "  inventory equipment")))
		SendMsgToChar("    !\r\n", ch);
	else {
		if (is_number(arg1)) {
			amount = std::stoi(arg1);
			theobj = arg2;
			thecont = arg3;
			theplace = arg4;
		} else {
			theobj = arg1;
			thecont = arg2;
			theplace = arg3;
		}

		if (isname(theplace, "  room ground"))
			where_bits = EFind::kObjRoom;
		else if (isname(theplace, " inventory"))
			where_bits = EFind::kObjInventory;
		else if (isname(theplace, " equipment"))
			where_bits = EFind::kObjEquip;

		cont_dotmode = find_all_dots(thecont);
		if (cont_dotmode == kFindIndiv) {
			mode = generic_find(thecont, where_bits, ch, &tmp_char, &cont);
			if (!cont) {
				sprintf(buf, "   '%s'.\r\n", arg2);
				SendMsgToChar(buf, ch);
			} else if (cont->get_type() != EObjType::kContainer) {
				act("$o -  .", false, ch, cont, nullptr, kToChar);
			} else {
				get_from_container(ch, cont, theobj, mode, amount, false);
			}
		} else {
			if (cont_dotmode == kFindAlldot
				&& !*thecont) {
				SendMsgToChar("   \"\"?\r\n", ch);
				return;
			}
			for (cont = ch->carrying; cont && IS_SET(where_bits, EFind::kObjInventory); cont = cont->get_next_content()) {
				if (CAN_SEE_OBJ(ch, cont)
					&& (cont_dotmode == kFindAll
						|| isname(thecont, cont->get_aliases())
						|| CHECK_CUSTOM_LABEL(thecont, cont, ch))) {
					if (cont->get_type() == EObjType::kContainer) {
						found = 1;
						get_from_container(ch, cont, theobj, EFind::kObjInventory, amount, false);
					} else if (cont_dotmode == kFindAlldot) {
						found = 1;
						act("$o -  .", false, ch, cont, nullptr, kToChar);
					}
				}
			}
			for (cont = world[ch->in_room]->contents; cont && IS_SET(where_bits, EFind::kObjRoom);
				 cont = cont->get_next_content()) {
				if (CAN_SEE_OBJ(ch, cont)
					&& (cont_dotmode == kFindAll
						|| isname(thecont, cont->get_aliases())
						|| CHECK_CUSTOM_LABEL(thecont, cont, ch))) {
					if (cont->get_type() == EObjType::kContainer) {
						get_from_container(ch, cont, theobj, EFind::kObjRoom, amount, false);
						found = 1;
					} else if (cont_dotmode == kFindAlldot) {
						act("$o -  .", false, ch, cont, nullptr, kToChar);
						found = 1;
					}
				}
			}
			if (!found) {
				if (cont_dotmode == kFindAll) {
					SendMsgToChar("      .\r\n", ch);
				} else {
					sprintf(buf, " -    '%s'.\r\n", thecont);
					SendMsgToChar(buf, ch);
				}
			}
		}
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
