#include "do_employ.h"

#include "engine/entities/char_data.h"
#include "engine/core/handler.h"
#include "gameplay/magic/magic_items.h"

void apply_enchant(CharData *ch, ObjData *obj, std::string text);

void do_employ(CharData *ch, char *argument, int cmd, int subcmd) {
	ObjData *mag_item;
	int do_hold = 0;
	two_arguments(argument, arg, buf);
	char *buf_temp = str_dup(buf);
	if (!*arg) {
		sprintf(buf2, "   %s?\r\n", cmd_info[cmd].command);
		SendMsgToChar(buf2, ch);
		return;
	}

	if (ch->IsFlagged(EPrf::kIronWind)) {
		SendMsgToChar("         !\r\n", ch);
		return;
	}

	mag_item = GET_EQ(ch, kHold);
	if (!mag_item
		|| !isname(arg, mag_item->get_aliases())) {
		switch (subcmd) {
			case SCMD_RECITE:
			case SCMD_QUAFF:
				if (!(mag_item = get_obj_in_list_vis(ch, arg, ch->carrying))) {
					snprintf(buf2, kMaxStringLength, ",    %s.\r\n", arg);
					SendMsgToChar(buf2, ch);
					return;
				}
				break;
			case SCMD_USE: mag_item = get_obj_in_list_vis(ch, arg, ch->carrying);
				if (!mag_item
					|| mag_item->get_type() != EObjType::kEnchant) {
					snprintf(buf2, kMaxStringLength, "   '%s'  !\r\n", arg);
					SendMsgToChar(buf2, ch);
					return;
				}
				break;
			default: log("SYSERR: Unknown subcmd %d passed to do_employ.", subcmd);
				return;
		}
	}
	switch (subcmd) {
		case SCMD_QUAFF:
			if (ch->IsFlagged(EPrf::kIronWind)) {
				SendMsgToChar("    !\r\n", ch);
				return;
			}
			if (mag_item->get_type() != EObjType::kPotion) {
				SendMsgToChar("     (,      ;)\r\n", ch);
				return;
			}
			do_hold = 1;
			break;
		case SCMD_RECITE:
			if (mag_item->get_type() != EObjType::kScroll) {
				SendMsgToChar("    .\r\n", ch);
				return;
			}
			do_hold = 1;
			break;
		case SCMD_USE:
			if (mag_item->get_type() == EObjType::kEnchant) {
				apply_enchant(ch, mag_item, buf);
				return;
			}
			if (mag_item->get_type() != EObjType::kWand
				&& mag_item->get_type() != EObjType::kStaff) {
				SendMsgToChar("    !\r\n", ch);
				return;
			}

			auto spell_id = static_cast<ESpell>(GET_OBJ_VAL(mag_item, 3));
			if (spell_id == ESpell::kCharm || spell_id == ESpell::kAnimateDead || spell_id == ESpell::kResurrection) {
				if (!CanUseFeat(ch, EFeat::kMagicUser)) {
					SendMsgToChar(",   !      . :(\r\n", ch);
					return;
				}
			}
			break;
	}
	if (do_hold && GET_EQ(ch, EEquipPos::kHold) != mag_item) {
		if (GET_EQ(ch, EEquipPos::kBoths))
			do_hold = EEquipPos::kBoths;
		else if (GET_EQ(ch, EEquipPos::kShield))
			do_hold = EEquipPos::kShield;
		else
			do_hold = EEquipPos::kHold;

		if (GET_EQ(ch, do_hold)) {
			act("   $o3.", false, ch, GET_EQ(ch, do_hold), 0, kToChar);
			act("$n $g  $o3.", false, ch, GET_EQ(ch, do_hold), 0, kToRoom | kToArenaListen);
			PlaceObjToInventory(UnequipChar(ch, do_hold, CharEquipFlags()), ch);
		}
		if (GET_EQ(ch, EEquipPos::kHold))
			PlaceObjToInventory(UnequipChar(ch, EEquipPos::kHold, CharEquipFlags()), ch);
		//obj_from_char(mag_item);
		EquipObj(ch, mag_item, EEquipPos::kHold, CharEquipFlags());
	}
	if ((do_hold && GET_EQ(ch, EEquipPos::kHold) == mag_item) || (!do_hold))
		EmployMagicItem(ch, mag_item, buf_temp);
	free(buf_temp);

}

void apply_enchant(CharData *ch, ObjData *obj, std::string text) {
	std::string tmp_buf;
	GetOneParam(text, tmp_buf);
	if (tmp_buf.empty()) {
		SendMsgToChar("  .\r\n", ch);
		return;
	}

	ObjData *target = get_obj_in_list_vis(ch, tmp_buf, ch->carrying);
	if (!target) {
		SendMsgToChar(ch, ",       .\r\n");
		return;
	}

	if (target->has_flag(EObjFlag::KSetItem)) {
		SendMsgToChar(ch, "     .\r\n");
		return;
	}
	if (target->get_type() == EObjType::kEnchant) {
		SendMsgToChar(ch, "        .\r\n");
		return;
	}

	if (target->get_enchants().check(ObjectEnchant::ENCHANT_FROM_OBJ)) {
		SendMsgToChar(ch, " %s   .\r\n",
					  target->get_PName(ECase::kAcc).c_str());
		return;
	}

	auto check_slots = obj->get_wear_flags() & target->get_wear_flags();
	if (check_slots > 0
		&& check_slots != to_underlying(EWearFlag::kTake)) {
		SendMsgToChar(ch, "   %s.\r\n", target->get_PName(ECase::kNom).c_str());
		ObjectEnchant::enchant ench(obj);
		ench.apply_to_obj(target);
		ExtractObjFromWorld(obj);
	} else {
		int slots = obj->get_wear_flags();
		REMOVE_BIT(slots, EWearFlag::kTake);
		if (sprintbit(slots, wear_bits, buf2)) {
			SendMsgToChar(ch, "       : %s\r\n", buf2);
		} else {
			SendMsgToChar(ch, " ,    .\r\n");
		}
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
