/**
\file do_drunkoff.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 28.10.2025.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/obj_data.h"
#include "engine/entities/char_data.h"
#include "engine/core/handler.h"
#include "gameplay/mechanics/liquid.h"
#include "engine/db/global_objects.h"
#include "engine/core/utils_char_obj.inl"
#include "gameplay/core/game_limits.h"

void do_drunkoff(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	ObjData *obj;
	struct TimedSkill timed;
	int amount, weight, prob, percent, duration;
	int on_ground = 0;

	if (ch->IsNpc())
		return;

	if (ch->GetEnemy()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	if (AFF_FLAGGED(ch, EAffect::kDrunked)) {
		SendMsgToChar("     ?\r\n" "    !\r\n", ch);
		return;
	}

	if (!AFF_FLAGGED(ch, EAffect::kAbstinent) && GET_COND(ch, DRUNK) < kDrunked) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}

	if (IsTimedBySkill(ch, ESkill::kHangovering)) {
		SendMsgToChar("      .\r\n"
					  "   .\r\n", ch);
		return;
	}

	one_argument(argument, arg);

	if (!*arg) {
		for (obj = ch->carrying; obj; obj = obj->get_next_content()) {
			if (obj->get_type() == EObjType::kLiquidContainer) {
				break;
			}
		}
		if (!obj) {
			SendMsgToChar("      .\r\n", ch);
			return;
		}
	} else if (!(obj = get_obj_in_list_vis(ch, arg, ch->carrying))) {
		if (!(obj = get_obj_in_list_vis(ch, arg, world[ch->in_room]->contents))) {
			SendMsgToChar("    !\r\n", ch);
			return;
		} else {
			on_ground = 1;
		}
	}

	if (obj->get_type() != EObjType::kLiquidContainer
		&& obj->get_type() != EObjType::kFountain) {
		SendMsgToChar("  -  .\r\n", ch);
		return;
	}

	if (on_ground && (obj->get_type() == EObjType::kLiquidContainer)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (!GET_OBJ_VAL(obj, 1)) {
		SendMsgToChar(".\r\n", ch);
		return;
	}

	switch (GET_OBJ_VAL(obj, 2)) {
		case LIQ_BEER:
		case LIQ_WINE:
		case LIQ_ALE:
		case LIQ_QUAS:
		case LIQ_BRANDY:
		case LIQ_VODKA:
		case LIQ_BRAGA: break;
		default: SendMsgToChar("   :\r\n" "\"  ...\"\r\n", ch);
			return;
	}

	amount = std::max(1, GET_WEIGHT(ch) / 50);
	if (amount > GET_OBJ_VAL(obj, 1)) {
		SendMsgToChar("       ...\r\n", ch);
		return;
	}

	timed.skill = ESkill::kHangovering;
	timed.time = 12;
	ImposeTimedSkill(ch, &timed);

	percent = number(1, MUD::Skill(ESkill::kHangovering).difficulty);
	prob = CalcCurrentSkill(ch, ESkill::kHangovering, nullptr);
	TrainSkill(ch, ESkill::kHangovering, percent <= prob, nullptr);
	amount = MIN(amount, GET_OBJ_VAL(obj, 1));
	weight = MIN(amount, obj->get_weight());
	weight_change_object(obj, -weight);    // Subtract amount //
	obj->sub_val(1, amount);
	if (!GET_OBJ_VAL(obj, 1))    // The last bit //
	{
		obj->set_val(2, 0);
		obj->set_val(3, 0);
		name_from_drinkcon(obj);
	}

	if (percent > prob) {
		sprintf(buf, "  %s  $o1,      ...", drinks[GET_OBJ_VAL(obj, 2)]);
		act(buf, false, ch, obj, 0, kToChar);
		act("$n $g ,     $m  .", false, ch, 0, 0, kToRoom);
		duration = std::max(1, amount / 3);
		Affect<EApply> af[3];
		af[0].type = ESpell::kAbstinent;
		af[0].duration = CalcDuration(ch, duration, 0, 0, 0, 0);
		af[0].modifier = 0;
		af[0].location = EApply::kDamroll;
		af[0].bitvector = to_underlying(EAffect::kAbstinent);
		af[0].battleflag = 0;
		af[1].type = ESpell::kAbstinent;
		af[1].duration = CalcDuration(ch, duration, 0, 0, 0, 0);
		af[1].modifier = 0;
		af[1].location = EApply::kHitroll;
		af[1].bitvector = to_underlying(EAffect::kAbstinent);
		af[1].battleflag = 0;
		af[2].type = ESpell::kAbstinent;
		af[2].duration = CalcDuration(ch, duration, 0, 0, 0, 0);
		af[2].modifier = 0;
		af[2].location = EApply::kAc;
		af[2].bitvector = to_underlying(EAffect::kAbstinent);
		af[2].battleflag = 0;
		switch (number(0, ch->GetSkill(ESkill::kHangovering) / 20)) {
			case 0:
			case 1: af[0].modifier = -2;
				break;
			case 2:
			case 3: af[0].modifier = -2;
				af[1].modifier = -2;
				break;
			default: af[0].modifier = -2;
				af[1].modifier = -2;
				af[2].modifier = 10;
				break;
		}
		for (prob = 0; prob < 3; prob++) {
			ImposeAffect(ch, af[prob], true, false, true, false);
		}
		gain_condition(ch, DRUNK, amount);
	} else {
		sprintf(buf, "  %s  $o1       ...",
				drinks[GET_OBJ_VAL(obj, 2)]);
		act(buf, false, ch, obj, 0, kToChar);
		act("$n $u  $g   .", false, ch, nullptr, nullptr, kToRoom);
		RemoveAffectFromCharAndRecalculate(ch, ESpell::kAbstinent);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
