/**
\file bandage.cpp - a part of Bylins engine.
\authors Created by Sventovit.
\date 11.09.2024.
\brief Do bandage command.
*/

#include "engine/entities/char_data.h"
#include "engine/core/handler.h"
#include "gameplay/affects/affect_data.h"

void DoBandage(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc()) {
		return;
	}
	if (ch->get_hit() == ch->get_real_max_hit()) {
		SendMsgToChar("    !\r\n", ch);
		return;
	}
	if (ch->GetEnemy()) {
		SendMsgToChar("       !\r\n", ch);
		return;
	}
	if (AFF_FLAGGED(ch, EAffect::kBandage)) {
		SendMsgToChar("     !\r\n", ch);
		return;
	}
	if (AFF_FLAGGED(ch, EAffect::kCannotBeBandaged)) {
		SendMsgToChar("       !\r\n", ch);
		return;
	}

	ObjData *bandage = nullptr;
	for (ObjData *i = ch->carrying; i; i = i->get_next_content()) {
		if (i->get_type() == EObjType::kBandage) {
			bandage = i;
			break;
		}
	}
	if (!bandage || bandage->get_weight() <= 0) {
		SendMsgToChar("       !\r\n", ch);
		return;
	}

	SendMsgToChar("        ...\r\n", ch);
	act("$n $g   .&n", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);

	Affect<EApply> af;
	af.type = ESpell::kBandage;
	af.location = EApply::kNone;
	af.modifier = GET_OBJ_VAL(bandage, 0);
	af.duration = CalcDuration(ch, 10, 0, 0, 0, 0);
	af.bitvector = to_underlying(EAffect::kBandage);
	af.battleflag = kAfPulsedec;
	ImposeAffect(ch, af, false, false, false, false);

	af.type = ESpell::kNoBandage;
	af.location = EApply::kNone;
	af.duration = CalcDuration(ch, 60, 0, 0, 0, 0);
	af.bitvector = to_underlying(EAffect::kCannotBeBandaged);
	af.battleflag = kAfPulsedec;
	ImposeAffect(ch, af, false, false, false, false);

	bandage->set_weight(bandage->get_weight() - 1);
	IS_CARRYING_W(ch) -= 1;
	if (bandage->get_weight() <= 0) {
		SendMsgToChar("     .\r\n", ch);
		ExtractObjFromWorld(bandage);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
