/*
 \authors Created by Sventovit
 \date 14.02.2022.
 \brief   .
 \details            ,
            .
 */

#ifndef BYLINS_SRC_BOOT_CFG_MANAGER_H_
#define BYLINS_SRC_BOOT_CFG_MANAGER_H_

#include <filesystem>
#include <unordered_map>
#include <utility>

#include "utils/parser_wrapper.h"

namespace cfg_manager {

/**
 *      .
 *      ,     ,
 *          .
 *    -    ( -  
 *   )   ,      , ( -
 *      )     
 *    /.
 */
class ICfgLoader {
 public:
	virtual void Load(parser_wrapper::DataNode data) = 0;
	virtual void Reload(parser_wrapper::DataNode data) = 0;
};

using LoaderPtr = std::unique_ptr<ICfgLoader>;

class CfgManager {
 public:
	CfgManager();

	void LoadCfg(const std::string &id);
	void ReloadCfg(const std::string &id);
 private:
	struct LoaderInfo {
		LoaderInfo(std::filesystem::path file, LoaderPtr loader) :
			file{std::move(file)}, loader{std::move(loader)} {};
		std::filesystem::path file;
		LoaderPtr loader;
	};

	std::unordered_map<std::string, LoaderInfo> loaders_;

};

} // namespace cfg manager

#endif //BYLINS_SRC_BOOT_CFG_MANAGER_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
