#ifndef __TINTIN_H_
#define __TINTIN_H_

#ifdef _TTCORE_DLL
#define DLLEXPORT __declspec( dllexport )
#else
#define DLLEXPORT __declspec( dllimport )
#endif


#define SUBST_ARRAY_SIZE 68
#define BUFFER_SIZE 2048


typedef void (CALLBACK* END_FUNC)(void);
typedef void (CALLBACK* DIRECT_OUT_FUNC)(char*, BOOL);
typedef void (CALLBACK* SET_HOTKEYS)(char*, char*);
typedef void (CALLBACK* SET_HOTSET)(char*);


void  DLLEXPORT InitState(DIRECT_OUT_FUNC OutFunc, HWND mainWnd);
void  DLLEXPORT CloseState(void);
void  DLLEXPORT ReloadScriptEngine(LPCSTR strScriptText, GUID guidEngine, LPCSTR strProfile);
void  DLLEXPORT CompileInput(char* str);
void  DLLEXPORT ReadMud();
BOOL  DLLEXPORT IsConnected();
BOOL  DLLEXPORT IsLogging();
BOOL  DLLEXPORT IsPathing();
BOOL  DLLEXPORT ParseScript(LPCSTR strScriptlet);
void  DLLEXPORT BreakScript();
void  DLLEXPORT LunchDebuger();

extern unsigned char DLLEXPORT substChars[SUBST_ARRAY_SIZE];
extern BOOL DLLEXPORT bSubstitution;
extern CRITICAL_SECTION DLLEXPORT secSubstSection;

extern char DLLEXPORT cCommandChar;
extern char DLLEXPORT cCommandDelimiter;
extern BOOL DLLEXPORT bDefaultLogMode; // TRUE - append , FALSE - ovewrite
extern BOOL DLLEXPORT bRMASupport;
extern BOOL DLLEXPORT bANSILog;
extern int DLLEXPORT iSecToTick;
extern BOOL DLLEXPORT bTickStatus;
extern BOOL DLLEXPORT bPasswordEcho ;
extern BOOL DLLEXPORT bConnectBeep;
extern BOOL DLLEXPORT bAutoReconnect;
extern BOOL DLLEXPORT bDisplayInput;
extern BOOL DLLEXPORT bHTML;
extern BOOL DLLEXPORT bAllowDebug;
extern BOOL DLLEXPORT bIACSendSingle, bIACReciveSingle;
extern int DLLEXPORT nScripterrorOutput;

extern int DLLEXPORT MoreComingDelay;

extern char DLLEXPORT strInfo1[BUFFER_SIZE];
extern char DLLEXPORT strInfo2[BUFFER_SIZE];
extern char DLLEXPORT strInfo3[BUFFER_SIZE];
extern CRITICAL_SECTION DLLEXPORT secStatusSection;

LPCSTR DLLEXPORT GetHotkeyValue(WORD key);

extern CRITICAL_SECTION DLLEXPORT secHotkeys;
extern HANDLE DLLEXPORT eventAllObjectEvent;

extern HANDLE DLLEXPORT eventMudEmuTextArrives;
extern int DLLEXPORT nMudEmuTextSize;
extern char DLLEXPORT strMudEmuText[513];


#endif /* */

